package com.gogirl.application.order.mall;

import com.github.binarywang.wxpay.bean.order.WxPayMpOrderResult;
import com.github.binarywang.wxpay.exception.WxPayException;

import java.net.UnknownHostException;

public interface MallOrderPayService {

    /**
     * 微信支付
     *
     * @param currentCustomerId
     * @param orderId
     * @return
     */
    WxPayMpOrderResult wxPayMallOrder(Integer currentCustomerId, Long orderId) throws UnknownHostException, WxPayException;


    /**
     * 余额支付
     *
     * @param currentCustomerId
     * @param orderId
     */
    void balancePayMallOrder(Integer currentCustomerId, Long orderId);

    /**
     * 余额微信混合支付
     *
     * @param currentCustomerId
     * @param orderId
     * @return
     */
    WxPayMpOrderResult balanceWxPayMallOrder(Integer currentCustomerId, Long orderId);

    /**
     * 朋友代付
     *
     * @param currentCustomerId
     * @param orderId
     * @param phone
     */
    void friendPayMallOrder(Integer currentCustomerId, Long orderId, String phone);

    /**
     * 商城订单回调
     *
     * @param orderId
     */
    void notifyMallOrder(Long orderId);

    /**
     * 退款接口
     *
     * @param orderDetailId
     */
    void refund(Long orderDetailId) throws WxPayException;
}
