//package com.gogirl.application.order.serve.impl;
//
//import com.github.binarywang.wxpay.bean.order.WxPayMpOrderResult;
//import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
//import com.github.binarywang.wxpay.exception.WxPayException;
//import com.gogirl.application.order.serve.OrderManageService;
//import com.gogirl.application.order.serve.PayQryService;
//import com.gogirl.domain.order.serve.MultiPaymentType;
//import com.gogirl.domain.order.serve.OrderManage;
//import com.gogirl.domain.user.customer.CustomerBalance;
//import com.gogirl.infrastructure.common.exception.RRException;
//import com.gogirl.infrastructure.config.property.GogirlProperties;
//import com.gogirl.infrastructure.feign.wx.WxPayControllerFeign;
//import com.gogirl.infrastructure.mapper.user.customer.CustomerBalanceMapper;
//import com.gogirl.shared.member.order.command.BalanceWxPayQuery;
//import com.gogirl.shared.member.order.query.UnifiedOrderQuery;
//import com.gogirl.shared.order.serve.query.qry.ordermanage.WxPayOrderQuery;
//import com.gogirl.infrastructure.common.util.JsonUtilByFsJson;
//import com.gogirl.infrastructure.common.util.RandomUtil;
//import com.google.common.collect.Lists;
//import lombok.AllArgsConstructor;
//import lombok.extern.slf4j.Slf4j;
//import org.springframework.stereotype.Service;
//import org.springframework.transaction.annotation.Transactional;
//
//import java.math.BigDecimal;
//import java.net.InetAddress;
//import java.net.UnknownHostException;
//import java.util.List;
//
//@Service
//@AllArgsConstructor
//@Slf4j
//public class PayQryServiceImpl implements PayQryService {
//
//    private final WxPayControllerFeign wxPayControllerFeign;
//
//
//    private final GogirlProperties gogirlProperties;
//
//    private final OrderManageService orderManageService;
//    private final CustomerBalanceMapper customerBalanceMapper;
//
//    @Override
//    public WxPayMpOrderResult unifiedOrder(UnifiedOrderQuery qry) throws UnknownHostException, WxPayException {
//
//        OrderManage orderManageDTO = orderManageService.queryOrder(qry.getOrderId());
//
//        WxPayOrderQuery qry2 = WxPayOrderQuery
//                .builder()
//                .currentCustomerId(qry.getCustomerId())
//                .openid(qry.getOpenid())
//                //避免同单不同金额的情况
//                .orderNo(RandomUtil.randomInt(100000, 999999) + orderManageDTO.getOrderNo())
//                .totalPaymentAmount(orderManageDTO.getTotalPaymentAmount())
//                .build();
//
//        WxPayUnifiedOrderRequest wxPayUnifiedOrderRequest =
//                WxPayUnifiedOrderRequest.newBuilder()
//                        .openid(qry.getOpenid())
//                        .tradeType("JSAPI")
//                        //todo
//                        .notifyUrl(gogirlProperties.getNotifyOrder())
//                        .spbillCreateIp(InetAddress.getLocalHost().getHostAddress())
//                        .totalFee(qry2.getTotalPaymentAmount().multiply(new BigDecimal(100)).intValue())
//                        .outTradeNo(qry2.getOrderNo())
//                        .body("gogirl美甲美睫")
//                        .build();
//        log.info("**微信下单参数构造**,{}", wxPayUnifiedOrderRequest.toString());
//
//        wxPayUnifiedOrderRequest.setNotifyUrl(gogirlProperties.getNotifyOrder());
//        //微信统一下单
//        return wxPayControllerFeign.createJsapiOrder(wxPayUnifiedOrderRequest);
//
//    }
//
//
//    @Transactional(timeout = 10000)
//    @Override
//    public WxPayMpOrderResult balanceWxPay(BalanceWxPayQuery qry) throws UnknownHostException, WxPayException {
//
//        OrderManage orderManageDTO = orderManageService.queryOrder(qry.getOrderId());
//
//        CustomerBalance customerBalance = customerBalanceMapper.selectByCustomerId(qry.getCustomerId());
//
//        if (orderManageDTO.getTotalPaymentAmount().multiply(new BigDecimal(100)).intValue() < customerBalance.getBalance()) {
//            throw new RRException("请使用余额支付");
//        }
//
//        BigDecimal leftTotalPaymentAmount = orderManageDTO.getTotalPaymentAmount().subtract(new BigDecimal(customerBalance.getBalance()).divide(new BigDecimal(100), 2, BigDecimal.ROUND_HALF_UP));
//
//        WxPayOrderQuery wxPayOrderQuery = WxPayOrderQuery.builder()
//                //避免同单不同金额的情况
//                .orderNo(RandomUtil.randomInt(100000, 999999) + orderManageDTO.getOrderNo())
//                .currentCustomerId(qry.getCustomerId())
//                .openid(qry.getOpenid())
//                .totalPaymentAmount(leftTotalPaymentAmount)
//                .build();
//
//        WxPayUnifiedOrderRequest wxPayUnifiedOrderRequest =
//                WxPayUnifiedOrderRequest.newBuilder()
//                        .openid(qry.getOpenid())
//                        .tradeType("JSAPI")
//                        //todo
//                        .notifyUrl(gogirlProperties.getNotifyBalanceWxPay())
//                        .spbillCreateIp(InetAddress.getLocalHost().getHostAddress())
//                        .totalFee(wxPayOrderQuery.getTotalPaymentAmount().multiply(new BigDecimal(100)).intValue())
//                        .outTradeNo(wxPayOrderQuery.getOrderNo())
//                        .body("gogirl美甲美睫")
//                        .build();
//
//        log.info("**微信下单参数构造**,{}", wxPayUnifiedOrderRequest.toString());
//        //微信统一下单
//        return wxPayControllerFeign.createJsapiOrder(wxPayUnifiedOrderRequest);
//    }
//
//    @Override
//    public void balancePosPay(Integer currentCustomerId, Integer orderId) {
//        OrderManage orderManage = orderManageService.getById(orderId);
//
//        CustomerBalance customerBalance = customerBalanceMapper.selectByCustomerId(currentCustomerId);
//
//        if (orderManage.getTotalPaymentAmount().multiply(new BigDecimal(100)).intValue() < customerBalance.getBalance()) {
//            throw new RRException("请使用余额支付");
//        }
//        //申请余额pos支付
//        orderManage.setPaymentType(13);
//
//        BigDecimal balanceAmount = new BigDecimal(customerBalance.getBalance()).divide(new BigDecimal(100), 100, BigDecimal.ROUND_HALF_UP);
//
//        MultiPaymentType balancePay = new MultiPaymentType(2, balanceAmount);
//        MultiPaymentType posPay = new MultiPaymentType(5, orderManage.getTotalPaymentAmount().subtract(balanceAmount));
//
//        List<MultiPaymentType> multiPaymentTypeList = Lists.newArrayList(balancePay, posPay);
//
//        orderManage.setMultiplePaymentType(JsonUtilByFsJson.beanToJson(multiPaymentTypeList));
//
//        //待确认支付
//        orderManage.setStatus(8);
//
//        orderManageService.updateById(orderManage);
//    }
//}
