package com.gogirl.shared.store;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.Date;

@Data
public class TrainingStartClassDTO {
    private Integer id;

    private Integer courseId;

    private String lecturer;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date time;

    private Integer duration;

    private Integer status;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    private TrainingCourseDTO trainingCourseDTO;

    @ApiModelProperty("结束时间")
    private LocalDateTime endTime;

    @ApiModelProperty("学员反馈")
    private String feedback;

    @ApiModelProperty("图片")
    private String picture_path;
}
