package com.gogirl.shared.order;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class ScheduleServeCommand implements Serializable {

    private Integer id;

    @ApiModelProperty("预约美甲师id")
    private Integer technicianId;

    private String technicianName;

    private String technicianIds;

    private String technicianNames;

    @ApiModelProperty("主服务id")
    private Integer mainServeId;

    @ApiModelProperty("服务时长")
    private Integer lengthTime;


    /**
     * 预约服务vo
     */
    @ApiModelProperty("预约服务id")
    private Integer serveId;

    @ApiModelProperty("服务名称")
    private String serveName;

    @ApiModelProperty("图片名称")
    private String servePicturePath;

    @ApiModelProperty("服务价格")
    private BigDecimal servePrice;

    @ApiModelProperty("服务数量")
    private Integer serveNumber;

    @ApiModelProperty("服务分类")
    private String serveType;

    /**
     * 预约款式vo
     */
    @ApiModelProperty("款式名称")
    private String produceName;

    @ApiModelProperty("款式图片地址")
    private String producePicturePath;

    @ApiModelProperty("款式当前价格")
    private BigDecimal produceCurrentPrice;

    @ApiModelProperty("款式特价")
    private BigDecimal produceBargainPrice;

    @ApiModelProperty("预约款式id")
    private Integer produceId;


    /**
     * 预约服务的价格
     */
    private BigDecimal price;

    @ApiModelProperty("开始时间")

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime;

    @ApiModelProperty("服务结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;

    @ApiModelProperty("售后说明")
    private String explain;

    private Integer status;

    private Boolean isCustomerPick;

    private Integer leisureDiscountConfigId;

    @ApiModelProperty("自带款式Id")
    private Integer ownProduceId;

    @ApiModelProperty("服务实际开始时间")
    private Date actualStartTime;
}
