package com.gogirl.shared.order;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class ScheduleManageCommand implements Serializable {

    private Integer id;


    @ApiModelProperty(value = "预约订单号", hidden = true)
    private String scheduledNo;

    @ApiModelProperty(value = "下单人id", hidden = true)
    private Integer scheduledUser;

    @ApiModelProperty(value = "店铺端预约手机号码")
    private String telephone;

    @ApiModelProperty(value = "店铺端预约用户名")
    private String storeScheduleUsername;

    @ApiModelProperty(value = "预约类型")
    private Integer scheduledType;

    @ApiModelProperty("总价")
    private BigDecimal totalPrice;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("预约到达时间")
    private Date arriveTime;

    @ApiModelProperty("下单店铺id")
    private Integer departmentId;

    @ApiModelProperty("下单店铺名称")
    private String departmentName;

    private Integer activityId;

    private List<ScheduleServeCommand> scheduleServeDTOList;

    private Integer version;

}
