package com.gogirl.domain.user.customer;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

@Data
@ApiModel("顾客消息")
@Builder
@TableName("customer_message")
public class CustomerMessage implements Serializable {
    public static final Integer STATUS_UN_READ = 1;
    public static final Integer STATUS_READIED = 2;
    public static final Integer TYPE_FRIEND_PAY = 1;
    public static final Integer TYPE_FRIEND_SCHEDULE_PAY = 2;
    public static final String PARAM_FRIEND_PAY_ORDER_ID = "orderId";
    public static final String PARAM_FRIEND_PAY_CUSTOMER_ID = "customerId";

    @TableId(type = IdType.AUTO)
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("顾客id")
    private Integer customerId;

    @ApiModelProperty("消息标题")
    private String header;

    @ApiModelProperty("消息内容")
    private String body;

    @ApiModelProperty("1-商城订单代收款消息  2-预约订单代收款消息")
    private Integer type;

    @ApiModelProperty("1-未读 2-已读")
    private Integer status;

    @ApiModelProperty("消息携带参数")
    private String paramsJson;

    @TableField(exist = false)
    private Map<String, Object> params;

}
