package com.gogirl.domain.store.store;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by yinyong on 2018/9/17.
 */
@ApiModel("店铺员工")
@Data
@TableName("store_user")
public class StoreUser implements Serializable {

    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("员工编号")
    private String no;

    @ApiModelProperty("员工姓名")
    private String name;

    @ApiModelProperty("头像url")
    private String picturePath;

    @ApiModelProperty("店铺id")
    private Integer departmentId;

    @ApiModelProperty("职责角色")
    private String jobs;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    private String mobile;

    @ApiModelProperty("状态：1#在职 2#离职")
    private Integer status;

    @ApiModelProperty("拥有权限")
    private String userAuthority;

    @ApiModelProperty("店铺对象")
    @TableField(exist = false)
    private StoreManage storeManage = new StoreManage();


}
