package com.gogirl.domain.product.purchase;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 出入库记录表
 * </p>
 *
 * @author luobin
 * @since 2019-11-26
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "PurchaseStockRecord对象", description = "出入库记录表")
@Builder
public class PurchaseStockRecord implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "库存id")
    private Integer stockId;

    @ApiModelProperty(value = "sku")
    private String sku;

    @ApiModelProperty(value = "1.入库;2.出库")
    private Integer type;

    @ApiModelProperty(value = "该次出入库数量")
    private Integer quantity;

    @ApiModelProperty(value = "店铺id")
    private Integer departmentId;

    @ApiModelProperty(value = "时间")
    private LocalDateTime time;

    @ApiModelProperty(value = "出入库后库存量")
    private Integer stockQuantity;

    private String remarks;

    @ApiModelProperty(value = "类型备注")
    private String typeRemarks;


}
