package com.gogirl.application.store.store.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.common.xcx.GogirlTokenService;
import com.gogirl.application.store.store.StoreClassesTechnicianService;
import com.gogirl.domain.common.sys.SysLog;
import com.gogirl.domain.common.xcx.GogirlToken;
import com.gogirl.domain.store.store.StoreClasses;
import com.gogirl.domain.store.store.StoreClassesTechnician;
import com.gogirl.domain.store.store.StoreTechnician;
import com.gogirl.infrastructure.common.util.JsonUtilByFsJson;
import com.gogirl.infrastructure.common.util.ListUtil;
import com.gogirl.infrastructure.common.util.SessionUtils;
import com.gogirl.infrastructure.mapper.common.xcx.SysLogMapper;
import com.gogirl.infrastructure.mapper.store.store.StoreClassesMapper;
import com.gogirl.infrastructure.mapper.store.store.StoreClassesTechnicianMapper;
import com.gogirl.infrastructure.mapper.store.store.StoreTechnicianMapper;
import com.gogirl.shared.store.UpdateDayTechnicianClassesReq;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;


@Transactional
@Service
@AllArgsConstructor
@Slf4j
public class StoreClassesTechnicianServiceImpl extends ServiceImpl<StoreClassesTechnicianMapper, StoreClassesTechnician> implements StoreClassesTechnicianService {

    private final StoreClassesTechnicianMapper storeClassesTechnicianMapper;

    private StoreClassesMapper storeClassesMapper;
    private final SysLogMapper sysLogMapper;

    private final GogirlTokenService gogirlTokenService;


    @Override
    public List<StoreClassesTechnician> listClassesTechnicianDetail(Integer userId, String days) {
        return storeClassesTechnicianMapper.listClassesTechnicianDetail(userId, days, SessionUtils.getTechnicianToken().getDepartmentId());
    }

    @Override
    public List<StoreTechnician> queryDayTechnicianClasses(Integer departmentId, Date day) {

        //查询店铺下的美甲师
        List<StoreTechnician> list = storeTechnicianMapper.queryDayTechnicianClasses(departmentId, day);

        list.forEach(storeTechnician -> {
            StoreClassesTechnician storeClassesTechnician = storeClassesTechnicianMapper.selectOneClassTech(departmentId, day, storeTechnician.getTechnicianId());

            if (storeClassesTechnician == null) {
                storeClassesTechnician = StoreClassesTechnician.builder()
                        .userId(storeTechnician.getTechnicianId())
                        .days(day)
                        .status(2)
                        .classes(-1)
                        .build();
                storeTechnician.setClassesTechnician(storeClassesTechnician);
            }
            //
            else if (storeClassesTechnician.getClasses() == 0) {
                storeTechnician.setClassesTechnician(storeClassesTechnician);
            }
            //
            else {
                StoreClasses storeClasses = storeClassesMapper.selectById(storeClassesTechnician.getClasses());

                if (storeClasses.getName().equals("早班")) {
                    storeClassesTechnician.setClasses(1);
                }
                if (storeClasses.getName().equals("晚班")) {
                    storeClassesTechnician.setClasses(2);
                }
                storeTechnician.setClassesTechnician(storeClassesTechnician);
            }
            storeTechnician.setId(storeTechnician.getTechnicianId());
        });
        list = list.stream()
                .collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(StoreTechnician::getId))), ArrayList::new));
        list.sort(Comparator.comparing(StoreTechnician::getId));
        return list;
    }

    @Override
    public void updateDayTechnicianClasses(UpdateDayTechnicianClassesReq updateDayTechnicianClassesReq) throws ParseException {
        String token = updateDayTechnicianClassesReq.getToken();

        String dayString = updateDayTechnicianClassesReq.getDayString();

        GogirlToken gogirlToken = gogirlTokenService.getByToken(token);
        Date day = new SimpleDateFormat("yyyy-MM-dd").parse(dayString);

        //店铺id
        Integer departmentId = gogirlToken.getDepartmentId();

        List<Integer> ids = storeClassesTechnicianMapper.deleteDayClassesIds(departmentId, day);
        if (ListUtil.isNotEmpty(ids)) {
            storeClassesTechnicianMapper.deleteBatchIds(ids);
        }

        List<StoreClassesTechnician> storeClassesTechnicianList = updateDayTechnicianClassesReq.getList()
                .stream()
                .filter(storeTechnician -> storeTechnician.getClassesTechnician().getClasses() != null)
                .filter(storeTechnician -> storeTechnician.getClassesTechnician().getClasses() > -1)
                .map(storeTechnician -> {
                    LambdaQueryWrapper<StoreClasses> wrapper = new LambdaQueryWrapper<>();
                    Integer classes = storeTechnician.getClassesTechnician().getClasses();
                    if (classes == 0) {
                        wrapper.eq(StoreClasses::getName, "休息");
                    } else if (classes == 1) {
                        wrapper.eq(StoreClasses::getName, "早班");
                        wrapper.eq(StoreClasses::getDepartmentId, departmentId);
                    } else if (classes == 2) {
                        wrapper.eq(StoreClasses::getName, "晚班");
                        wrapper.eq(StoreClasses::getDepartmentId, departmentId);
                    }

                    StoreClasses storeClasses = storeClassesMapper.selectOne(wrapper);
                    StoreClassesTechnician storeClassesTechnician = StoreClassesTechnician.builder()
                            .classes(storeClasses.getId())
                            .status(2)
                            .days(day)
                            .userId(storeTechnician.getId())
                            .build();
                    if (storeClasses.getName().equals("休息")) {
                        storeClassesTechnician.setClasses(0);
                    }
                    return storeClassesTechnician;
                })
                .collect(Collectors.toList());
        this.saveBatch(storeClassesTechnicianList);

        Integer technicianId = SessionUtils.getTechnicianId();
        StoreTechnician storeTechnician = storeTechnicianMapper.selectById(technicianId);
        SysLog sysLog = SysLog.builder()
                .createDate(new Date())
                .createUser(storeTechnician.getId())
                .createUserName(storeTechnician.getName())
                .oldVal(JsonUtilByFsJson.beanToJson(ids))
                .newVal(JsonUtilByFsJson.beanToJson(storeClassesTechnicianList))
                .tableName("store_classes")
                .field("")
                .build();

        sysLogMapper.insert(sysLog);
    }

    @Override
    public List<StoreClassesTechnician> getReservableTime(String startDate, String startTime, Integer departmentId) {
        return storeClassesTechnicianMapper.listClassTimeByStartDate(startDate, startTime, departmentId);
    }

    private final StoreTechnicianMapper storeTechnicianMapper;


}
