package com.gogirl.application.product.serve.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.product.serve.BaseBroadcastService;
import com.gogirl.domain.product.serve.BaseBroadcast;
import com.gogirl.infrastructure.mapper.product.serve.BaseBroadcastMapper;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by yinyong on 2018/9/25.
 */
@Service
public class BaseBroadcastServiceImpl extends ServiceImpl<BaseBroadcastMapper, BaseBroadcast> implements BaseBroadcastService {


    @Override
    public List<BaseBroadcast> queryBroadcast(Integer positionType) {
        LambdaQueryWrapper<BaseBroadcast> wrapper = new LambdaQueryWrapper<>();
        if (positionType != null) {
            wrapper.eq(BaseBroadcast::getPositionType, positionType);
        }
        wrapper.orderBy(true, true, BaseBroadcast::getSort);
        return this.list(wrapper);
    }
}
