package com.gogirl.application.order.mall.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.order.mall.IMallOrderTechnicianService;
import com.gogirl.domain.order.mall.MallOrder;
import com.gogirl.domain.order.mall.MallOrderDetail;
import com.gogirl.domain.order.mall.MallOrderTechnician;
import com.gogirl.domain.user.customer.Customer;
import com.gogirl.infrastructure.common.util.ListUtil;
import com.gogirl.infrastructure.mapper.order.mall.MallOrderDetailMapper;
import com.gogirl.infrastructure.mapper.order.mall.MallOrderMapper;
import com.gogirl.infrastructure.mapper.order.mall.MallOrderTechnicianMapper;
import com.gogirl.infrastructure.mapper.user.customer.CustomerMapper;
import com.gogirl.shared.order.mall.QueryMallOrderAchievementRequest;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * <p>
 * 商城订单  - 美甲师 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-06-22
 */
@Service
public class MallOrderTechnicianServiceImpl extends ServiceImpl<MallOrderTechnicianMapper, MallOrderTechnician> implements IMallOrderTechnicianService {

    @Resource
    MallOrderMapper mallOrderMapper;
    @Resource
    MallOrderDetailMapper mallOrderDetailMapper;
    @Resource
    CustomerMapper customerMapper;


    @Override
    public Page<MallOrderTechnician> queryMallOrderAchievement(QueryMallOrderAchievementRequest request) {
        Page<MallOrderTechnician> mallOrderTechnicianList = baseMapper.queryMallOrderAchievement(new Page<>(request.getPageNum(), request.getPageSize()), request);

        List<Long> mallOrderIdList = mallOrderTechnicianList.getRecords().stream()
                .map(MallOrderTechnician::getMallOrderId).filter(Objects::nonNull).collect(Collectors.toList());

        if (ListUtil.isNotEmpty(mallOrderIdList)) {
            Map<Long, MallOrder> mallOrderMap = mallOrderMapper.selectBatchIds(mallOrderIdList)
                    .stream()
                    .collect(Collectors.toMap(MallOrder::getId, mallOrder -> mallOrder, (k1, k2) -> k1));

            Map<Long, List<MallOrderDetail>> mallOrderDetailMap = mallOrderDetailMapper.selectList(new LambdaQueryWrapper<MallOrderDetail>().in(MallOrderDetail::getOrderId, mallOrderIdList))
                    .stream()
                    .collect(Collectors.groupingBy(MallOrderDetail::getOrderId));

            List<Integer> customerIdList = mallOrderMap.values().stream().map(MallOrder::getCustomerId).collect(Collectors.toList());
            Map<Integer, Customer> customerMap = customerMapper.selectBatchIds(customerIdList)
                    .stream()
                    .collect(Collectors.toMap(Customer::getId, customer -> customer, (k1, k2) -> k1));

            mallOrderMap.forEach((mallOrderId, mallOrder) -> {
                mallOrder.setMallOrderDetailList(mallOrderDetailMap.get(mallOrderId));
                mallOrder.setCustomer(customerMap.get(mallOrder.getCustomerId()));
            });

            mallOrderTechnicianList.getRecords().forEach(mallOrderTechnician -> {
                mallOrderTechnician.setMallOrder(mallOrderMap.get(mallOrderTechnician.getMallOrderId()));
            });
        }
        return mallOrderTechnicianList;
    }

    @Override
    public BigDecimal queryTotalMallOrderAchievement(Integer technicianId, Integer departmentId, String date) {
        return baseMapper.queryTotalMallOrderAchievement(technicianId, departmentId, date);
    }
}
