package com.gogirl.application.market.coupon.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.market.coupon.CouponService;
import com.gogirl.application.market.coupon.ICouponsGiftService;
import com.gogirl.domain.market.coupon.CouponsForConsumption;
import com.gogirl.domain.market.coupon.CouponsGift;
import com.gogirl.domain.user.customer.Customer;
import com.gogirl.infrastructure.common.util.StringUtils;
import com.gogirl.infrastructure.feign.AdminFeign;
import com.gogirl.infrastructure.mapper.market.coupon.CouponsForConsumptionMapper;
import com.gogirl.infrastructure.mapper.market.coupon.CouponsGiftMapper;
import com.gogirl.infrastructure.mapper.user.customer.CustomerMapper;
import com.gogirl.shared.admin.dashboard.req.SendMessageRequest;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-11-10
 */
@Slf4j
@Service
public class CouponsGiftServiceImpl extends ServiceImpl<CouponsGiftMapper, CouponsGift> implements ICouponsGiftService {

    @Resource
    CouponService couponService;
    @Resource
    CustomerMapper customerMapper;

    @Resource
    @Lazy
    AdminFeign adminFeign;

    @Resource
    CouponsForConsumptionMapper couponsForConsumptionMapper;

    @Override
    public void sendGift(Integer customerId, Integer behavior, Object attach) {
        try {
            switch (behavior) {
                case CouponsGift.BEHAVIOR_COMMENT:
                case CouponsGift.BEHAVIOR_SURVEY:
                    CouponsGift couponsGift = this.getOne(new LambdaQueryWrapper<CouponsGift>()
                            .eq(CouponsGift::getBehavior, behavior));
                    if (couponsGift != null) {
                        if (couponsGift.getCouponId() != null) {
                            couponService.sendCoupon(couponsGift.getCouponId(), customerId);
                        }
                        if (StringUtils.isNotEmpty(couponsGift.getMessageInfo())) {
                            Customer customer = customerMapper.selectById(customerId);
                            SendMessageRequest sendMessageRequest = new SendMessageRequest();
                            sendMessageRequest.setContent(couponsGift.getMessageInfo());
                            sendMessageRequest.setMobiles(Lists.newArrayList(customer.getPhone()));
                            adminFeign.sendMessage(sendMessageRequest);
                        }
                    }
                    break;
                case CouponsGift.BEHAVIOR_FINISH_ORDER:
                    Integer orderId = Integer.parseInt(attach.toString());
                    CouponsForConsumption couponsForConsumption = couponsForConsumptionMapper.getByOrderId(orderId);
                    if (couponsForConsumption.getCouponId() != null) {
                        couponService.sendCoupon(couponsForConsumption.getCouponId(), customerId);
                    }
                    if (StringUtils.isNotEmpty(couponsForConsumption.getMessageInfo())) {
                        Customer customer = customerMapper.selectById(customerId);
                        SendMessageRequest sendMessageRequest = new SendMessageRequest();
                        sendMessageRequest.setContent(couponsForConsumption.getMessageInfo());
                        sendMessageRequest.setMobiles(Lists.newArrayList(customer.getPhone()));
                        adminFeign.sendMessage(sendMessageRequest);
                    }
            }
        } catch (Exception e) {
            log.error("行为触发发券失败");
        }
    }
}
