package com.gogirl.application.user.customer;

import com.baomidou.mybatisplus.extension.service.IService;
import com.gogirl.domain.user.customer.Customer;
import com.gogirl.dto.customer.CustomerOrderDetail;

import java.security.InvalidAlgorithmParameterException;
import java.util.List;

public interface CustomerService extends IService<Customer> {


    /**
     * 根据手机号查询会员
     *
     * @param phone phone
     * @return customer
     */
    Customer selectByPhone(String phone);

    /**
     * 根据id查询会员
     *
     * @param scheduledUser id
     * @return customer
     */
    Customer selectByCustomerId(Integer scheduledUser);


    /**
     * 用户登陆
     *
     * @param code 微信小程序code
     * @return 服务器登陆状态token
     */
    String login(String code);


    /**
     * 授权地址信息
     *
     * @param customerId
     * @param province
     * @param city
     * @param area
     * @param street
     */
    void bindAddressInfo(Integer customerId, String province, String city, String area, String street);


    /**
     * 授权信息
     *
     * @param token
     * @param encryptedData
     * @param iv
     * @return
     */
    Customer authorized1(String token, String encryptedData, String iv) throws InvalidAlgorithmParameterException;

    /**
     * 授权手机号码
     *
     * @param token
     * @param encryptedData
     * @param iv
     * @return
     */
    Customer authorizedPhone(String token, String encryptedData, String iv) throws InvalidAlgorithmParameterException;

    /**
     * 根据token获取customer
     *
     * @param token
     * @return
     */
    Customer getUserInfo(String token) throws Exception;

    /**
     * 查询订单用户详情
     *
     * @param customerId 用户id
     * @param orderId    订单id
     * @return
     */
    CustomerOrderDetail queryCustomerDetail(Integer customerId, Integer orderId);


    /**
     * 美甲师更新用户信息
     *
     * @param birthdayMonth
     * @param birthdayDay
     * @param ageGroup
     * @param customerId
     * @param orderId
     * @param orderServeId
     * @param storeRecordRealName
     * @param sex
     * @param age
     * @param job
     * @param preference
     * @param character
     * @param customerSource
     */
    void updateCustomerDetail(Integer birthdayMonth, Integer birthdayDay, String ageGroup, Integer customerId, Integer orderId, Integer orderServeId, String storeRecordRealName, String sex, Integer age, String job, String preference, String character, Integer customerSource);

    /**
     * 查询用户可选年龄段
     *
     * @return
     */
    List<String> getAgeGroups();

    /**
     * h5用户根据订单Id登录
     *
     * @param orderId
     * @return
     */
    String h5Login(Integer orderId);
}
