package com.gogirl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.gogirl.domain.xcx.TimeNode;
import com.gogirl.domain.xcx.WeekConfig;
import com.gogirl.infrastructure.mapper.market.discount.LeisureDiscountConfigWeekMapper;
import com.gogirl.infrastructure.mapper.xcx.TimeNodeMapper;
import com.gogirl.infrastructure.mapper.xcx.WeekConfigMapper;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import javax.annotation.Resource;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

@RunWith(SpringRunner.class)
@SpringBootTest
public class Test {

    @Resource
    private TimeNodeMapper timeNodeMapper;

    @org.junit.Test
    public void test() throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        LocalTime localTime = LocalTime.of(0, 0);
        LocalTime localTime2 = LocalTime.of(23, 45);


        while (localTime.compareTo(localTime2) < 0) {
            TimeNode timeNode = new TimeNode();
            timeNode.setTimeNode(localTime);
            timeNodeMapper.insert(timeNode);
            localTime = localTime.plusMinutes(15);
        }
    }

    @Resource
    private LeisureDiscountConfigWeekMapper leisureDiscountConfigWeekMapper;
    @Resource
    private WeekConfigMapper weekConfigMapper;

    @org.junit.Test
    public void weekTest() throws ParseException {

        weekConfigMapper.delete(new LambdaQueryWrapper<>());

        LocalDate localDate = LocalDate.now();
        for (int i = 0; i < 7; i++) {
            WeekConfig weekConfig = new WeekConfig();
            weekConfig.setWeek(localDate.getDayOfWeek().getValue());
            weekConfig.setWeekStr(localDate.getDayOfWeek().toString());
            weekConfig.setWeekDate(localDate);
            weekConfigMapper.insert(weekConfig);
            localDate = localDate.plusDays(1);
        }
    }


}
