package com.gogirl.interfaces.product.serve;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.gogirl.application.product.serve.BaseProduceService;
import com.gogirl.application.product.serve.BaseServeService;
import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.domain.product.serve.BaseProduce;
import com.gogirl.domain.product.serve.BaseServe;
import com.gogirl.domain.xcx.GogirlToken;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.util.StringUtils;
import com.gogirl.infrastructure.mapper.market.discount.LeisureDiscountConfigMapper;
import com.gogirl.infrastructure.mapper.product.serve.BaseServeMapper;
import com.gogirl.infrastructure.mapper.product.serve.PraiseRecordMapper;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@RestController
@Api(tags = {"预约服务接口"}, value = "预约服务接口")
@AllArgsConstructor
@Slf4j
public class ServeController {

    private final BaseServeService baseServeService;
    private final BaseProduceService baseProduceService;
    private final GogirlTokenService tokenService;
    private final PraiseRecordMapper praiseRecordMapper;
    private final LeisureDiscountConfigMapper leisureDiscountConfigMapper;
    private final BaseServeMapper baseServeMapper;



    @ApiOperation(value = "查看服务详情")
    @GetMapping("/customer/serve/getServeDetail")
    public JsonResult<BaseServe> getServeDetail(@RequestParam Integer id,
                                                @RequestParam(required = false) Date date) {
        BaseServe baseServe = baseServeService.getAggregate(id, date);
        return JsonResult.success(baseServe);
    }

    @ApiOperation(value = "查看服务列表")
    @GetMapping("/customer/serve/no_queryServeForPage")
    @Deprecated
    public JsonResult<PageInfo<BaseServe>> no_queryServeForPage(BaseServe param,
                                                                Integer pageNum,
                                                                Integer pageSize,
                                                                Integer labelId,
                                                                String serveIds,
                                                                String time) {
        if (pageNum != null && pageSize != null) {
            PageHelper.startPage(pageNum, pageSize);
        }
        if (labelId != null && labelId == -1) {
            labelId = null;
        }
        List<Integer> serveIdList;
        if (StringUtils.isNotEmpty(serveIds)) {
            serveIdList = Lists.newArrayList(serveIds.split(",")).stream().map(Integer::valueOf).collect(Collectors.toList());
        } else {
            serveIdList = new ArrayList<>();
        }

        Date today = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(today);
        int weekday = c.get(Calendar.DAY_OF_WEEK);
        if (weekday == 1) weekday = 7;
        else weekday = weekday - 1;

        param.setServeLabelId(labelId);
        List<BaseServe> baseServeList;
        if (StringUtils.isEmpty(time))
            baseServeList = baseServeService.listServeForPage(param, serveIdList);
        else
            baseServeList = baseServeMapper.listLeisureServeForPage(param, serveIdList, time, weekday);

        return JsonResult.success(new PageInfo<>(baseServeList));
    }

    @ApiOperation(value = "查看服务详情")
    @GetMapping("/technician/serve/getServeDetail")
    public JsonResult<BaseServe> technicianGetServeDetail(@RequestParam Integer id,
                                                          @RequestParam(required = false) Date date) {
        BaseServe baseServe = baseServeService.getAggregate(id, date);
        return JsonResult.success(baseServe);
    }


    @RequestMapping(method = {RequestMethod.GET, RequestMethod.POST}, value = "/technician/serve/queryServeForPage")
    @ApiOperation(value = "查询服务款式", notes = "查看服务列表")
    public JsonResult<PageInfo<BaseServe>> queryServeForPage(BaseServe baseServe,
                                                             @RequestParam(required = false) Integer pageNum,
                                                             @RequestParam(required = false) Integer pageSize) {
        if (pageNum != null && pageSize != null) {
            PageHelper.startPage(pageNum, pageSize);
        }
        List<BaseServe> lists = baseServeService.listServeForPage(baseServe, null);
        PageInfo<BaseServe> pageInfo = new PageInfo<>(lists);
        return JsonResult.success(pageInfo);
    }

}
