package com.gogirl.infrastructure.util;

import com.gogirl.domain.xcx.GogirlToken;

public class SessionUtils {


    private static final ThreadLocal<GogirlToken> technicianTokenThreadLocal = new ThreadLocal<>();
    private static final ThreadLocal<GogirlToken> customerTokenThreadLocal = new ThreadLocal<>();

    public static void putTechnicianToken(GogirlToken gogirlToken) {
        technicianTokenThreadLocal.set(gogirlToken);
    }

    public static GogirlToken getTechnicianToken() {
        return technicianTokenThreadLocal.get();
    }

    public static void removeTechnicianToken() {
        technicianTokenThreadLocal.remove();
    }

    public static void putCustomerToken(GogirlToken gogirlToken) {
        customerTokenThreadLocal.set(gogirlToken);
    }

    public static GogirlToken getCustomerToken() {
        return customerTokenThreadLocal.get();
    }

    public static void removeCustomerToken() {
        customerTokenThreadLocal.remove();
    }


    public static Integer getTechnicianId() {
        return technicianTokenThreadLocal.get().getTechnicianId();
    }

    public static Integer getCustomerId() {
        return customerTokenThreadLocal.get().getCustomerId();
    }

}
