package com.gogirl.domain.order.serve;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;

@TableName("produce_promotion_time")
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Data
public class ProducePromotionTime {

    @TableId(type = IdType.AUTO)
    private Integer id;
    private Integer produceId;
    private Date startTime;
    private Date endTime;

    @ApiModelProperty("活动价格")
    private BigDecimal price;

    public boolean isPromotion() {
        return startTime.getTime() < System.currentTimeMillis() &&
                endTime.getTime() > System.currentTimeMillis();
    }
}
