package com.gogirl.domain.market.timescard;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 次卡次数详情使用情况
 */
@Data
@AllArgsConstructor
@Builder
@TableName("times_card_order_serve_detail")
public class TimesCardOrderServeDetail {

    @TableId(type = IdType.AUTO)
    private Integer id;

    /**
     * 该次次卡使用记录在对应服务上折扣的金额
     */
    private BigDecimal discountAmount;

    /**
     * 该次次卡使用记录在对应服务
     */
    @ApiModelProperty("订单服务id")
    private Integer orderServeId;

    /**
     * 该次次卡使用记录在对应服务上的实付金额
     */
    @ApiModelProperty("支付")
    private BigDecimal payForOrderServe;

    /**
     * 该次次卡使用记录id
     */
    private Integer timesCardUserRecordId;
}
