package com.gogirl.domain.market.timescard;


import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@ApiModel("用户次卡")
@TableName("times_card_customer_relevance")
@Data
@Builder
public class TimesCardCustomerRelevance {


    @TableId(type = IdType.AUTO)
    private Integer id;
    @ApiModelProperty("次卡种类id")
    private Integer cardTypeId;
    private String name;
    @ApiModelProperty("次卡持有人id")
    private Integer customerId;
    @ApiModelProperty("单次优惠价格")
    private BigDecimal discountAmount;
    @ApiModelProperty("单次算业绩价格")
    private BigDecimal payAmount;
    @ApiModelProperty("购卡时间")
    private Date createTime;
    @ApiModelProperty("已使用次数")
    private Integer usedTimes;
    @ApiModelProperty("总共使用次数")
    private Integer sumTimes;
    @ApiModelProperty("有效期,开始时间")
    private Date validStartTime;
    @ApiModelProperty("有效期,截止时间")
    private Date validEndTime;
    @ApiModelProperty("购卡推荐人")
    private String refereeId;
    @ApiModelProperty("1正常使用;2.次数用完;3.已过期;")
    private Integer status;

    @TableField(exist = false)
    private TimesCardType timesCardType;

    @TableField(exist = false)
    private List<TimesCardUsedRecord> timesCardUsedRecordList;

    public static Integer STATUS_NORMAL = 1;
    public static Integer STATUS_END = 2;
    public static Integer STATUS_OVER_TIME = 3;

    /**
     * 次卡是否可用
     *
     * @return
     */
    public boolean isValid() {
        return validStartTime.getTime() < System.currentTimeMillis()
                && validEndTime.getTime() > System.currentTimeMillis();
    }
}
