package com.gogirl.assembler;

import com.gogirl.domain.store.training.TrainingStartClassLogTechnician;
import com.gogirl.shared.store.query.dto.TrainingStartClassLogTechnicianDTO;
import lombok.AllArgsConstructor;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

import java.util.function.Function;

@Component
@AllArgsConstructor
public class TrainingStartClassLogTechnicianDTOAssembler implements Function<TrainingStartClassLogTechnician, TrainingStartClassLogTechnicianDTO> {
    private TrainingStartClassDTOAssembler trainingStartClassDTOAssembler;

    @Override
    public TrainingStartClassLogTechnicianDTO apply(TrainingStartClassLogTechnician trainingStartClassLogTechnician) {
        TrainingStartClassLogTechnicianDTO trainingStartClassLogTechnicianDTO = new TrainingStartClassLogTechnicianDTO();
        BeanUtils.copyProperties(trainingStartClassLogTechnician, trainingStartClassLogTechnicianDTO);
        trainingStartClassLogTechnicianDTO.setTrainingStartClassDTO(trainingStartClassDTOAssembler
                .apply(trainingStartClassLogTechnician.getTrainingStartClass()));
        return trainingStartClassLogTechnicianDTO;
    }
}
