package com.gogirl.interfaces.store;


import com.gogirl.application.store.store.StoreClassesService;
import com.gogirl.application.store.store.StoreClassesTechnicianService;
import com.gogirl.application.store.store.StoreTechnicianService;
import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.domain.store.store.StoreClassesTechnician;
import com.gogirl.domain.store.store.StoreTechnician;
import com.gogirl.domain.xcx.GogirlToken;
import com.gogirl.dto.ParmTechnicianClasses;
import com.gogirl.infrastructure.common.annotation.GogirlShop;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.mapper.store.store.StoreClassesTechnicianMapper;
import com.gogirl.infrastructure.mapper.xcx.SysLogMapper;
import com.gogirl.infrastructure.util.SessionUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

@Api(tags = {"11.美甲师排班"}, value = "美甲师排班")
@RestController
@Slf4j
@AllArgsConstructor
public class ClassesTechnicianController {


    private final StoreClassesTechnicianService storeClassesTechnicianService;
    private final GogirlTokenService gogirlTokenService;
    private final StoreClassesService storeClassesService;
    private final StoreTechnicianService storeTechnicianService;

    private final StoreClassesTechnicianMapper storeClassesTechnicianMapper;
    private final SysLogMapper sysLogMapper;

    @ApiOperation(value = "美甲师端查询当天店铺排班")
    @GetMapping("/technician/classestechnician/queryDayTechnicianClasses")
    @GogirlShop
    public JsonResult<List<StoreTechnician>> queryDayTechnicianClasses(String token,
                                                                       String dayString) throws ParseException {
        GogirlToken gogirlToken = SessionUtils.getTechnicianToken();
        log.info("查询美甲师当当天排班 technicianId :{}", gogirlToken.getTechnicianId());
        Date day = new SimpleDateFormat("yyyy-MM-dd").parse(dayString);
        Integer departmentId = gogirlToken.getDepartmentId();
        List<StoreTechnician> list = storeClassesTechnicianService.queryDayTechnicianClasses(departmentId, day);
        return JsonResult.success(list);
    }

    @ApiOperation(value = "美甲师端提交当天店铺排班")
    @PostMapping("/technician/classestechnician/updateDayTechnicianClasses")
    public JsonResult<Void> updateDayTechnicianClasses(@RequestBody ParmTechnicianClasses parmTechnicianClasses) throws ParseException {

        storeClassesTechnicianService.updateDayTechnicianClasses(parmTechnicianClasses);
        return JsonResult.success();
    }


    @ApiOperation(value = "美甲师端查询当月排班排班")
    @GetMapping("/technician/classestechnician/queryMonthClasses")
    public JsonResult<List<StoreClassesTechnician>> queryMonthClasses(String token,
                                                                      String month) {

        Integer departmentId = SessionUtils.getTechnicianToken().getDepartmentId();
        List<StoreClassesTechnician> lists = storeClassesService.queryMonthClasses(SessionUtils.getTechnicianId(), departmentId, month);
        return JsonResult.success(lists);
    }

}
