package com.gogirl.application.product.serve;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.gogirl.domain.product.serve.BaseFeatures;
import com.gogirl.domain.product.serve.BaseProduce;

import java.util.List;

/**
 * Created by yinyong on 2018/8/23.
 * 服务款式 服务接口
 */
public interface BaseProduceService extends IService<BaseProduce> {

    /**
     * 查询款式详情
     *
     * @param id 款式id
     * @return 款式详情
     */
    BaseProduce getProduceForDetail(Integer id);

    /**
     * 查询首页新品服务款式
     *
     * @param customerId     当前登陆用户id 作为点赞表的连接查询条件，可以为空
     * @param produceLabelId 款式特性id {@link BaseFeatures}
     * @return 款式列表
     */
    List<BaseProduce> queryNewServePage(Integer customerId, Integer produceLabelId);

    /**
     * 分页查询款式列表
     *
     * @param featuresId  款式特性id
     * @param serveTypeId
     * @param pageNum
     * @param pageSize
     * @return
     */
    IPage<BaseProduce> queryProducePage(Integer featuresId, Integer serveTypeId, Integer pageNum, Integer pageSize);

    /**
     * 点赞款式
     * @param produceId
     */
    void praiseProduce(Integer produceId);
}
