package com.gogirl.shared.store.query.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class TakeLeaveEventDTO {

    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("请假美甲师id")
    private Integer applyTechnicianId;

    @ApiModelProperty("1-加班 2-调休 3-事假 4-病假 5-外出 6-婚假")
    private Integer type;

    @ApiModelProperty("开始时间")
    private Long startTime;

    @ApiModelProperty("结束时间")
    private Long endTime;

    @ApiModelProperty("请假时长")
    private Integer timeLength;

    @ApiModelProperty("申请理由")
    private String applyReason;

    @ApiModelProperty("拒绝理由")
    private String rejectReason;

    @ApiModelProperty("拒绝的美甲师id")
    private String rejectTechnicianId;

    @ApiModelProperty("拒绝的美甲师id")
    private String rejectTechnicianName;

    @ApiModelProperty("处理中的美甲师id")
    private Integer dealingTechnicianId;

    @ApiModelProperty("处理中的美甲师姓名")
    private String dealingTechnicianName;

    @ApiModelProperty("1-待审批 2-审批通过 3-审批拒绝")
    private Integer status;

    private Long createTime;

    private StoreTechnicianDTO applyStoreTechnicianDTO;
}
