package com.gogirl.interfaces.order.mall;

import com.gogirl.application.order.mall.MallCustomerAddressService;
import com.gogirl.domain.order.mall.MallCustomerAddress;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.util.SessionUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api(tags = "商城收获地址接口")
@RestController
@AllArgsConstructor
public class MallCustomerAddressController {

    private final MallCustomerAddressService mallCustomerAddressService;

    @ApiOperation("新增收获地址")
    @PostMapping("/customer/customerAddress/addMallCustomerAddress")
    public JsonResult<MallCustomerAddress> addMallCustomerAddress(@RequestBody MallCustomerAddress mallCustomerAddress) {
        Integer currentCustomerId = SessionUtils.getCustomerId();
        mallCustomerAddress.setCustomerId(currentCustomerId);
        mallCustomerAddress.setIsDefault(MallCustomerAddress.IS_DEFAULT_FALSE);
        mallCustomerAddressService.addMallCustomerAddress(mallCustomerAddress);
        return JsonResult.success(mallCustomerAddress);
    }

    @ApiOperation("修改收货地址")
    @PostMapping("/customer/customerAddress/changeMallCustomerAddress")
    public JsonResult<MallCustomerAddress> changeMallCustomerAddress(@RequestBody MallCustomerAddress mallCustomerAddress) {
        Integer currentCustomerId = SessionUtils.getCustomerId();
        mallCustomerAddress.setCustomerId(currentCustomerId);
        mallCustomerAddressService.changeMallCustomerAddress(mallCustomerAddress);
        return JsonResult.success(mallCustomerAddress);
    }

    @ApiOperation("收获地址列表")
    @GetMapping("/customer/customerAddress/listMallCustomerAddress")
    public JsonResult<List<MallCustomerAddress>> listMallCustomerAddress() {
        Integer currentCustomerId = SessionUtils.getCustomerId();
        List<MallCustomerAddress> list = mallCustomerAddressService.listMallCustomerAddress(currentCustomerId);
        return JsonResult.success(list);
    }

    @ApiOperation("修改默认收货地址")
    @GetMapping("/customer/customerAddress/updateDefaultMallCustomerAddress/{mallCustomerAddressId}")
    public JsonResult<MallCustomerAddress> updateDefaultMallCustomerAddress(@PathVariable Long mallCustomerAddressId) {
        Integer currentCustomerId = SessionUtils.getCustomerId();
        MallCustomerAddress mallCustomerAddress = mallCustomerAddressService.updateDefaultMallCustomerAddress(currentCustomerId, mallCustomerAddressId);
        return JsonResult.success(mallCustomerAddress);
    }


    @ApiOperation("获取默认收货地址")
    @GetMapping("/customer/customerAddress/getDefaultMallCustomerAddress")
    public JsonResult<MallCustomerAddress> getDefaultMallCustomerAddress() {
        Integer currentCustomerId = SessionUtils.getCustomerId();
        MallCustomerAddress mallCustomerAddress = mallCustomerAddressService.getDefaultMallCustomerAddress(currentCustomerId);
        return JsonResult.success(mallCustomerAddress);
    }
}
