package com.gogirl.domain.store.complaint;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 *
 * </p>
 *
 * @author luobin
 * @since 2019-11-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "ComplaintMain对象", description = "")
public class ComplaintMain implements Serializable {

    //来源 售后问卷
    public static final Integer SOURCE_DXDP = 1;
    //来源 小程序
    public static final Integer SOURCE_MP = 2;
    //来源 其他
    public static final Integer SOURCE_OTHER = 3;
    private static final long serialVersionUID = 1L;

    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createDate;

    @ApiModelProperty(value = "创建人")
    private Integer createUser;

    @ApiModelProperty(value = "来源： 售后问卷  = 1, 小程序 = 2")
    private Integer source;

    private String channel;

    @ApiModelProperty(value = "备注")
    private String remarks;

    @ApiModelProperty(value = "客户id")
    private Integer customerId;

    @ApiModelProperty(value = "订单id")
    private Integer orderId;

    @ApiModelProperty(value = "门店id")
    private Integer storeId;

    @ApiModelProperty(value = "照片")
    private String picturePath;
}
