package com.gogirl.infrastructure.common.base;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 实体类公共父类
 *
 * @author robbendev
 */
@Data
public class BaseModel implements Serializable {

    /**
     * 序列化
     */
    private static final long serialVersionUID = -4636716497382947499L;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "记录创建时间", hidden = true)
    @TableField(fill = FieldFill.INSERT)
    protected Long createTime;

    /**
     * 最后修改时间
     */
    @ApiModelProperty(value = "记录最后修改时间", hidden = true)
    @TableField(fill = FieldFill.INSERT_UPDATE)
    protected Long lastUpdateTime;

    /**
     * 记录状态，A：有效，X：删除，如有其它带业务属性的状态请通过业务状态字段实现
     */
    @ApiModelProperty(value = "记录状态，A：有效，X：删除，如有其它带业务属性的状态请通过业务状态字段实现", hidden = true)
    @TableField(fill = FieldFill.INSERT)
    @TableLogic
    protected String state;

    /**
     * 多租户数据来源
     */
    @ApiModelProperty(value = "多租户数据来源", hidden = true)
    @TableField(fill = FieldFill.INSERT)
    protected String sourceFrom;


    @ApiModelProperty(value = "创建人用户Id", hidden = true)
    @TableField(fill = FieldFill.INSERT)
    private Integer createUserId;

    @ApiModelProperty(value = "创建人", hidden = true)
    @TableField(fill = FieldFill.INSERT)
    private String createUserName;
}
