package com.gogirl.interfaces.store;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.gogirl.application.store.store.StoreClassesService;
import com.gogirl.application.store.store.StoreClassesTechnicianService;
import com.gogirl.application.store.store.StoreTechnicianService;
import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.domain.store.store.StoreClasses;
import com.gogirl.domain.store.store.StoreClassesTechnician;
import com.gogirl.domain.store.store.StoreTechnician;
import com.gogirl.domain.xcx.GogirlToken;
import com.gogirl.domain.xcx.SysLog;
import com.gogirl.dto.ParmTechnicianClasses;
import com.gogirl.infrastructure.common.annotation.GogirlShop;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.util.JsonUtilByFsJson;
import com.gogirl.infrastructure.common.util.ListUtil;
import com.gogirl.infrastructure.mapper.store.StoreClassesTechnicianMapper;
import com.gogirl.infrastructure.mapper.xcx.SysLogMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@Api(tags = {"11.美甲师排班"}, value = "美甲师排班")
@RestController
@Slf4j
@AllArgsConstructor
public class ClassesTechnicianController {


    private final StoreClassesTechnicianService storeClassesTechnicianService;
    private final GogirlTokenService gogirlTokenService;
    private final StoreClassesService storeClassesService;
    private final StoreTechnicianService storeTechnicianService;

    private final StoreClassesTechnicianMapper storeClassesTechnicianMapper;
    private final SysLogMapper sysLogMapper;

    @ApiOperation(value = "美甲师端查询当天店铺排班")
    @GetMapping("/technician/classestechnician/queryDayTechnicianClasses")
    @GogirlShop
    public JsonResult<List<StoreTechnician>> queryDayTechnicianClasses(String token,
                                                                       String dayString) throws ParseException {
        GogirlToken gogirlToken = gogirlTokenService.getTokenByToken_t(token);

        Date day = new SimpleDateFormat("yyyy-MM-dd").parse(dayString);

        Integer departmentId = gogirlToken.getStoreTechnician().getDepartmentId();

        //查询店铺下的美甲师
        List<StoreTechnician> list = storeTechnicianService.queryDayTechnicianClasses(departmentId, day);

        list.forEach(storeTechnician -> {
            StoreClassesTechnician storeClassesTechnician = storeClassesTechnicianMapper.selectOneClassTech(departmentId, day, storeTechnician.getTechnicianId());

            if (storeClassesTechnician == null) {
                storeClassesTechnician = StoreClassesTechnician.builder()
                        .userId(storeTechnician.getTechnicianId())
                        .days(day)
                        .status(2)
                        .classes(-1)
                        .build();
                storeTechnician.setClassesTechnician(storeClassesTechnician);
            }
            //
            else if (storeClassesTechnician.getClasses() == 0) {
                storeTechnician.setClassesTechnician(storeClassesTechnician);
            }
            //
            else {
                StoreClasses storeClasses = storeClassesService.getById(storeClassesTechnician.getClasses());

                if (storeClasses.getName().equals("早班")) {
                    storeClassesTechnician.setClasses(1);
                }
                if (storeClasses.getName().equals("晚班")) {
                    storeClassesTechnician.setClasses(2);
                }
                storeTechnician.setClassesTechnician(storeClassesTechnician);
            }
            storeTechnician.setId(storeTechnician.getTechnicianId());
        });
        list.sort(Comparator.comparing(StoreTechnician::getId));
        return JsonResult.success(list);
    }

    @ApiOperation(value = "美甲师端提交当天店铺排班")
    @PostMapping("/technician/classestechnician/updateDayTechnicianClasses")
    @GogirlShop
    public JsonResult<Object> updateDayTechnicianClasses(@RequestBody ParmTechnicianClasses ParmTechnicianClasses) throws ParseException {

        String token = ParmTechnicianClasses.getToken();

        String dayString = ParmTechnicianClasses.getDayString();

        GogirlToken gogirlToken = gogirlTokenService.getTokenByToken_t(token);

        Date day = new SimpleDateFormat("yyyy-MM-dd").parse(dayString);

        //店铺id
        Integer departmentId = gogirlToken.getStoreTechnician().getDepartmentId();

        List<Integer> ids = storeClassesTechnicianMapper.deleteDayClassesIds(departmentId, day);
        if (ListUtil.isNotEmpty(ids)) {
            storeClassesTechnicianMapper.deleteBatchIds(ids);
        }

        List<StoreClassesTechnician> storeClassesTechnicianList = ParmTechnicianClasses.getList()
                .stream()
                .filter(storeTechnician -> storeTechnician.getClassesTechnician().getClasses() != null)
                .filter(storeTechnician -> storeTechnician.getClassesTechnician().getClasses() > -1)
                .map(storeTechnician -> {
                    LambdaQueryWrapper<StoreClasses> wrapper = new LambdaQueryWrapper<>();
                    Integer classes = storeTechnician.getClassesTechnician().getClasses();
                    if (classes == 0) {
                        wrapper.eq(StoreClasses::getName, "休息");
                    } else if (classes == 1) {
                        wrapper.eq(StoreClasses::getName, "早班");
                        wrapper.eq(StoreClasses::getDepartmentId, departmentId);
                    } else if (classes == 2) {
                        wrapper.eq(StoreClasses::getName, "晚班");
                        wrapper.eq(StoreClasses::getDepartmentId, departmentId);
                    }

                    StoreClasses storeClasses = storeClassesService.getOne(wrapper);
                    StoreClassesTechnician storeClassesTechnician = StoreClassesTechnician.builder()
                            .classes(storeClasses.getId())
                            .status(2)
                            .days(day)
                            .userId(storeTechnician.getId())
                            .build();
                    if (storeClasses.getName().equals("休息")) {
                        storeClassesTechnician.setClasses(0);
                    }
                    return storeClassesTechnician;
                })
                .collect(Collectors.toList());
        storeClassesTechnicianService.saveBatch(storeClassesTechnicianList);

        SysLog sysLog = SysLog.builder()
                .createDate(new Date())
                .createUser(gogirlToken.getStoreTechnician().getTechnicianId())
                .createUserName(gogirlToken.getStoreTechnician().getName())
                .oldVal(JsonUtilByFsJson.beanToJson(ids))
                .newVal(JsonUtilByFsJson.beanToJson(storeClassesTechnicianList))
                .tableName("store_classes")
                .field("")
                .build();

        sysLogMapper.insert(sysLog);

        return new JsonResult<>(true, JsonResult.APP_DEFINE_SUC, null);
    }


    @ApiOperation(value = "美甲师端查询当月排班排班")
    @GetMapping("/technician/classestechnician/queryMonthClasses")
    public JsonResult<List<StoreClassesTechnician>> queryMonthClasses(String token, Integer technicianId, String month) {

        GogirlToken gogirlToken = gogirlTokenService.getTokenByToken_t(token);

        Integer departmentId = gogirlToken.getStoreTechnician().getDepartmentId();

        List<StoreClasses> classList = storeClassesService.list(new LambdaQueryWrapper<StoreClasses>().eq(StoreClasses::getDepartmentId, departmentId));

        Map<Integer, Integer> map = new HashMap<Integer, Integer>();//处理一个对应关系只返回012
        map.put(0, 0);
        for (int i = 0; i < classList.size(); i++) {
            StoreClasses item = classList.get(i);
            if (item.getName().equals("早班")) {
                map.put(item.getId(), 1);
            } else if (item.getName().equals("晚班")) {
                map.put(item.getId(), 2);
            }
        }

        List<StoreClassesTechnician> lists = storeClassesTechnicianService.listClassesTechnicianDetail(gogirlToken.getStoreTechnician().getTechnicianId(), month);
        //替换排班的class
        for (StoreClassesTechnician item : lists) {
            item.setClasses(map.get(item.getClasses()));
        }
        return new JsonResult<>(true, JsonResult.APP_DEFINE_SUC, lists);
    }


}
