package com.gogirl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.gogirl.domain.market.coupon.CouponCustomerRelevance;
import com.gogirl.domain.order.pay.OrderPay;
import com.gogirl.domain.order.serve.MultiPaymentType;
import com.gogirl.domain.order.serve.OrderManage;
import com.gogirl.domain.xcx.TimeNode;
import com.gogirl.domain.xcx.WeekConfig;
import com.gogirl.infrastructure.common.util.JsonUtilByFsJson;
import com.gogirl.infrastructure.mapper.market.coupon.CouponCustomerRelevanceMapper;
import com.gogirl.infrastructure.mapper.market.discount.LeisureDiscountConfigWeekMapper;
import com.gogirl.infrastructure.mapper.order.pay.OrderPayMapper;
import com.gogirl.infrastructure.mapper.order.serve.OrderManageMapper;
import com.gogirl.infrastructure.mapper.xcx.TimeNodeMapper;
import com.gogirl.infrastructure.mapper.xcx.WeekConfigMapper;
import lombok.extern.slf4j.Slf4j;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import javax.annotation.Resource;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;

@RunWith(SpringRunner.class)
@SpringBootTest
@Slf4j
public class Test {

    @Resource
    private TimeNodeMapper timeNodeMapper;

    @org.junit.Test
    public void timeNode() throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        LocalTime localTime = LocalTime.of(0, 0);
        LocalTime localTime2 = LocalTime.of(23, 45);


        while (localTime.compareTo(localTime2) < 0) {
            TimeNode timeNode = new TimeNode();
            timeNode.setTimeNode(localTime);
            timeNodeMapper.insert(timeNode);
            localTime = localTime.plusMinutes(15);
        }
    }

    @Resource
    private LeisureDiscountConfigWeekMapper leisureDiscountConfigWeekMapper;
    @Resource
    private WeekConfigMapper weekConfigMapper;

    @org.junit.Test
    public void weekTest() throws ParseException {

        weekConfigMapper.delete(new LambdaQueryWrapper<>());

        LocalDate localDate = LocalDate.now();
        for (int i = 0; i < 7; i++) {
            WeekConfig weekConfig = new WeekConfig();
            weekConfig.setWeek(localDate.getDayOfWeek().getValue());
            weekConfig.setWeekStr(localDate.getDayOfWeek().toString());
            weekConfig.setWeekDate(localDate);
            weekConfigMapper.insert(weekConfig);
            localDate = localDate.plusDays(1);
        }
    }

    @Resource
    OrderPayMapper orderPayMapper;
    @Resource
    OrderManageMapper orderManageMapper;
    @Resource
    CouponCustomerRelevanceMapper couponCustomerRelevanceMapper;

    @org.junit.Test
    public void orderPay() {

        orderPayMapper.delete(new LambdaQueryWrapper<>());

        List<OrderManage> orderManageList = orderManageMapper.selectList(new LambdaQueryWrapper<OrderManage>()
                .gt(OrderManage::getFinishTime, "2020-01-01"));


        // order_pay 微信 = 1, 会员 = 2, 充值 = 4, pos机 = 5, 大众点评 = 7, 会员帮付 = 11, 次卡 =12
        //1#微信 2#会员 3#其他4#充值5#pos机6#现金7#大众点评8#微信扫码支付9#团购10#免单11#会员帮付12#余额抵扣微信支付13余额pos支付
        orderManageList.forEach(orderManage -> {
            if (orderManage.getPaymentType().equals(1)) {
                OrderPay orderPay = new OrderPay();
                orderPay.setAmount(orderManage.getTotalPaymentAmount());
                orderPay.setOrderId(orderManage.getId());
                orderPay.setType(1);
                orderPayMapper.insert(orderPay);
            }
            if (orderManage.getPaymentType().equals(2)) {
                OrderPay orderPay = new OrderPay();
                orderPay.setAmount(orderManage.getTotalPaymentAmount());
                orderPay.setOrderId(orderManage.getId());
                orderPay.setType(2);
                orderPayMapper.insert(orderPay);
            }
            if (orderManage.getPaymentType().equals(5)) {
                OrderPay orderPay = new OrderPay();
                orderPay.setAmount(orderManage.getTotalPaymentAmount());
                orderPay.setOrderId(orderManage.getId());
                orderPay.setType(5);
                orderPayMapper.insert(orderPay);
            }

            if (orderManage.getPaymentType().equals(12) || orderManage.getPaymentType().equals(13)) {

                try {
                    List<MultiPaymentType> multiPaymentTypeList = JsonUtilByFsJson.jsonToList(orderManage.getMultiplePaymentType(), MultiPaymentType.class);
                    multiPaymentTypeList.forEach(multiPaymentType -> {
                        if (multiPaymentType.getType().equals(1)) {
                            OrderPay orderPay = new OrderPay();
                            orderPay.setAmount(multiPaymentType.getPrice());
                            orderPay.setOrderId(orderManage.getId());
                            orderPay.setType(1);
                            orderPayMapper.insert(orderPay);
                        }
                        if (multiPaymentType.getType().equals(2)) {
                            OrderPay orderPay = new OrderPay();
                            orderPay.setAmount(multiPaymentType.getPrice());
                            orderPay.setOrderId(orderManage.getId());
                            orderPay.setType(2);
                            orderPayMapper.insert(orderPay);
                        }

                        if (multiPaymentType.getType().equals(5)) {
                            OrderPay orderPay = new OrderPay();
                            orderPay.setAmount(multiPaymentType.getPrice());
                            orderPay.setOrderId(orderManage.getId());
                            orderPay.setType(5);
                            orderPayMapper.insert(orderPay);
                        }
                    });
                } catch (Exception e) {
                    log.error("orderId:no multi :{}", orderManage.getId());
                }
            }
        });

        orderPayMapper.delete(new LambdaQueryWrapper<OrderPay>().eq(OrderPay::getAmount, 0));
    }


    @org.junit.Test
    public void customerPay() {

        List<CouponCustomerRelevance> couponCustomerRelevanceList = couponCustomerRelevanceMapper.selectByOrderTimes();

        couponCustomerRelevanceList.forEach(couponCustomerRelevance -> {
            if (couponCustomerRelevance.getSourceType().equals(1)) {
                OrderPay orderPay = new OrderPay();
                orderPay.setAmount(couponCustomerRelevance.getPayAmount());
                orderPay.setOrderId(couponCustomerRelevance.getOrderId());
                orderPay.setType(7);
                orderPayMapper.insert(orderPay);
            }
        });
    }
}
