package com.gogirl.application.order.serve.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.github.binarywang.wxpay.bean.order.WxPayMpOrderResult;
import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.gogirl.application.market.MarketService;
import com.gogirl.application.order.serve.OrderManageService;
import com.gogirl.application.order.serve.PayService;
import com.gogirl.application.user.customer.CustomerBalanceService;
import com.gogirl.domain.order.serve.MultiPaymentType;
import com.gogirl.domain.order.serve.OrderManage;
import com.gogirl.domain.user.customer.CustomerBalance;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.infrastructure.common.util.JsonUtilByFsJson;
import com.gogirl.infrastructure.common.util.RandomUtil;
import com.gogirl.infrastructure.config.property.GogirlProperties;
import com.gogirl.infrastructure.feign.wx.WxPayControllerFeign;
import com.gogirl.infrastructure.mapper.market.discount.DiscountConfigMapper;
import com.gogirl.infrastructure.mapper.order.serve.OrderManageMapper;
import com.gogirl.infrastructure.mapper.user.customer.CustomerBalanceMapper;
import com.gogirl.infrastructure.mapper.user.customer.CustomerBalanceRecordMapper;
import com.gogirl.infrastructure.mapper.user.customer.CustomerMapper;
import com.gogirl.shared.member.order.command.BalanceWxPayQuery;
import com.gogirl.shared.member.order.query.UnifiedOrderQuery;
import com.gogirl.shared.order.serve.query.qry.ordermanage.WxPayOrderQuery;
import com.gogirl.shared.user.command.ConsumerCommand;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.List;

@Service
@AllArgsConstructor
@Slf4j
@Transactional
public class PayServiceImpl implements PayService {


    private final CustomerBalanceMapper customerBalanceMapper;
    private final CustomerBalanceRecordMapper customerBalanceRecordMapper;
    private final CustomerMapper customerMapper;
    private final DiscountConfigMapper discountConfigMapper;

    private final OrderManageService orderManageService;
    private final MarketService marketService;
    private final WxPayControllerFeign wxPayControllerFeign;


    private final GogirlProperties gogirlProperties;
    private final CustomerBalanceService customerBalanceService;
    private final OrderManageMapper orderManageMapper;

    @Override
    public void consumeBalance(Integer currentCustomerId, Integer orderId) {

        OrderManage orderManage = orderManageService.queryOrder(orderId);

        /*step1.扣除余额*/
        ConsumerCommand consumerCmd = ConsumerCommand.builder()
                .amount(orderManage.getTotalPaymentAmount().multiply(new BigDecimal(100)).intValue())
                .customerId(currentCustomerId)
                .departmentId(orderManage.getDepartmentId())
                .orderId(orderId)
                .orderStatus(orderManage.getStatus())
                .build();
        customerBalanceService.consumer(consumerCmd);

        /*step2.更新订单*/
        orderManage.setRemark("余额支付");
        orderManageService.updateById(orderManage);


        orderManage.setFinishTime(new Date());
        orderManage.setPaymentType(OrderManage.PAYMENT_BALANCE);
        orderManage.setStatus(OrderManage.STATUS_UN_COMMENT);
        orderManageService.updateById(orderManage);


        /*step3.更新卡券状态*/
        log.debug("更新卡券状态");
        marketService.setterOrderMarket(orderManage.getId());
    }

    @Override
    public void notifyOrder(String wxScheduleOrderNo, Integer paymentType) {

        String orderNo = wxScheduleOrderNo.substring(6);
        OrderManage orderManage = orderManageService.queryOrderByOrderNo(orderNo);

        /*1.更新订单状态*/
        log.info("设置订单折扣详情 orderManageDTO {}", orderManage);

        log.info("更新订单状态");
        //订单状态 待评价
        orderManage.setStatus(OrderManage.STATUS_UN_COMMENT);

        //支付方式
        orderManage.setPaymentType(paymentType);
        orderManage.setFinishTime(new Date());
        orderManage.setUpdateTime(new Date());
        orderManageService.updateById(orderManage);

        /*2.更新卡券状态*/
        marketService.setterOrderMarket(orderManage.getId());

    }


    @Override
    public WxPayMpOrderResult unifiedOrder(UnifiedOrderQuery qry) throws UnknownHostException, WxPayException {

        OrderManage orderManage = orderManageService.queryOrder(qry.getOrderId());

        WxPayOrderQuery qry2 = WxPayOrderQuery
                .builder()
                .currentCustomerId(qry.getCustomerId())
                .openid(qry.getOpenid())
                //避免同单不同金额的情况
                .orderNo(RandomUtil.randomInt(100000, 999999) + orderManage.getOrderNo())
                .totalPaymentAmount(orderManage.getTotalPaymentAmount())
                .build();

        WxPayUnifiedOrderRequest wxPayUnifiedOrderRequest =
                WxPayUnifiedOrderRequest.newBuilder()
                        .openid(qry.getOpenid())
                        .tradeType("JSAPI")
                        //todo
                        .notifyUrl(gogirlProperties.getNotifyOrder())
                        .spbillCreateIp(InetAddress.getLocalHost().getHostAddress())
                        .totalFee(qry2.getTotalPaymentAmount().multiply(new BigDecimal(100)).intValue())
                        .outTradeNo(qry2.getOrderNo())
                        .body("gogirl美甲美睫")
                        .build();
        log.info("**微信下单参数构造**,{}", wxPayUnifiedOrderRequest.toString());

        wxPayUnifiedOrderRequest.setNotifyUrl(gogirlProperties.getNotifyOrder());
        //微信统一下单
        return wxPayControllerFeign.createJsapiOrder(wxPayUnifiedOrderRequest);

    }

    @Override
    public WxPayMpOrderResult balanceWxPay(BalanceWxPayQuery qry) throws UnknownHostException, WxPayException {

        OrderManage orderManageDTO = orderManageService.queryOrder(qry.getOrderId());

        CustomerBalance customerBalance = customerBalanceMapper.selectOne(new LambdaQueryWrapper<CustomerBalance>().eq(CustomerBalance::getCustomerId, orderManageDTO.getOrderUser()));

        if (orderManageDTO.getTotalPaymentAmount().multiply(new BigDecimal(100)).intValue() < customerBalance.getBalance()) {
            throw new RRException("请使用余额支付");
        }

        BigDecimal leftTotalPaymentAmount = orderManageDTO.getTotalPaymentAmount().subtract(new BigDecimal(customerBalance.getBalance()).divide(new BigDecimal(100), 2, BigDecimal.ROUND_HALF_UP));

        WxPayOrderQuery wxPayOrderQuery = WxPayOrderQuery.builder()
                //避免同单不同金额的情况
                .orderNo(RandomUtil.randomInt(100000, 999999) + orderManageDTO.getOrderNo())
                .currentCustomerId(qry.getCustomerId())
                .openid(qry.getOpenid())
                .totalPaymentAmount(leftTotalPaymentAmount)
                .build();

        WxPayUnifiedOrderRequest wxPayUnifiedOrderRequest =
                WxPayUnifiedOrderRequest.newBuilder()
                        .openid(qry.getOpenid())
                        .tradeType("JSAPI")
                        //todo
                        .notifyUrl(gogirlProperties.getNotifyBalanceWxPay())
                        .spbillCreateIp(InetAddress.getLocalHost().getHostAddress())
                        .totalFee(wxPayOrderQuery.getTotalPaymentAmount().multiply(new BigDecimal(100)).intValue())
                        .outTradeNo(wxPayOrderQuery.getOrderNo())
                        .body("gogirl美甲美睫")
                        .build();

        log.info("**微信下单参数构造**,{}", wxPayUnifiedOrderRequest.toString());
        //微信统一下单
        return wxPayControllerFeign.createJsapiOrder(wxPayUnifiedOrderRequest);
    }

    @Override
    public void balancePosPay(Integer currentCustomerId, Integer orderId) {
        OrderManage orderManage = orderManageService.getById(orderId);

        CustomerBalance customerBalance = customerBalanceMapper.selectOne(new LambdaQueryWrapper<CustomerBalance>().eq(CustomerBalance::getCustomerId, currentCustomerId));

        if (orderManage.getTotalPaymentAmount().multiply(new BigDecimal(100)).intValue() < customerBalance.getBalance()) {
            throw new RRException("请使用余额支付");
        }
        //申请余额pos支付
        orderManage.setPaymentType(13);


        //多种方式支付字段构建
        BigDecimal balanceAmount = new BigDecimal(customerBalance.getBalance()).divide(new BigDecimal(100), 100, BigDecimal.ROUND_HALF_UP);

        MultiPaymentType balancePay = new MultiPaymentType(2, balanceAmount);
        MultiPaymentType posPay = new MultiPaymentType(5, orderManage.getTotalPaymentAmount().subtract(balanceAmount));

        List<MultiPaymentType> multiPaymentTypeList = Lists.newArrayList(balancePay, posPay);

        orderManage.setMultiplePaymentType(JsonUtilByFsJson.beanToJson(multiPaymentTypeList));

        //待确认支付
        orderManage.setStatus(8);
        orderManageService.updateById(orderManage);
    }

    @Override
    public void chosePayType(Integer orderId, Integer payType) {

        OrderManage orderManage = orderManageMapper.selectById(orderId);

        //客户申请pos机支付
        if (payType.equals(5)) {
            //状态待确认
            orderManage.setStatus(OrderManage.STATUS_UN_CONFIRM);
            //支付类型状态pos机
            orderManage.setPaymentType(OrderManage.PAYMENT_POS);
            orderManageMapper.updateById(orderManage);
        }
        //客户申请团购支付
        else if (payType.equals(7)) {
            //状态待确认
            orderManage.setStatus(OrderManage.STATUS_UN_CONFIRM);
            //支付类型状态pos机
            orderManage.setPaymentType(OrderManage.PAYMENT_DZ);
            orderManageMapper.updateById(orderManage);
        } else {
            throw new RRException(500, "invalid payType");
        }
    }
}
