package com.gogirl.application.product.serve.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.product.serve.BaseServeService;
import com.gogirl.domain.product.serve.BaseProduce;
import com.gogirl.domain.product.serve.BaseServe;
import com.gogirl.infrastructure.mapper.market.discount.LeisureDiscountConfigMapper;
import com.gogirl.infrastructure.mapper.product.serve.BaseProduceMapper;
import com.gogirl.infrastructure.mapper.product.serve.BaseServeMapper;
import com.gogirl.infrastructure.util.SessionUtils;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;

@Service
@AllArgsConstructor
public class BaseServeServiceImpl extends ServiceImpl<BaseServeMapper, BaseServe> implements BaseServeService {

    private final BaseServeMapper baseServeMapper;
    private final LeisureDiscountConfigMapper leisureDiscountConfigMapper;
    private final BaseProduceMapper baseProduceMapper;


    @Override
    public IPage<BaseServe> listServeForPage(IPage<BaseServe> page, BaseServe param, List<Integer> serveIdList) {
        return baseServeMapper.listServeForPage(page, param, serveIdList);
    }


    @Override
    public BaseServe getAggregate(Integer id, LocalDateTime date, Integer departmentId) {


        BaseServe baseServe = baseServeMapper.selectById(id);
        if (SessionUtils.getSourceFrom().equals(SessionUtils.technician)) {
            List<BaseProduce> baseProduceList = baseProduceMapper.selectList(new LambdaQueryWrapper<BaseProduce>().eq(BaseProduce::getServiceId, id));
            baseServe.setListProduce(baseProduceList);
        }
        return baseServe;
    }
}
