package com.gogirl.shared.store.query.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.sql.Time;
import java.util.Date;
import java.util.List;

@Data
public class StoreManageDTO {

    private Integer id;

    @ApiModelProperty("店铺编号")
    private String storeNo;

    @ApiModelProperty("logo")
    private String logo;

    @ApiModelProperty("店铺名称")
    private String name;

    @ApiModelProperty("经度")
    private String longitude;

    @ApiModelProperty("纬度")
    private String latitude;

    @ApiModelProperty("地址")
    private String address;

    @ApiModelProperty("店长")
    private String master;

    @ApiModelProperty("员工数量")
    private Integer employeeNumber;

    @ApiModelProperty("客服电话")
    private String customerServiceTelphone;

    @ApiModelProperty("联系人名称")
    private String contactName;

    @ApiModelProperty("联系电话")
    private String contactTelphone;

    @ApiModelProperty("营业周天")
    private Integer businessDay;

    @ApiModelProperty("营业开始时间")
    @JsonFormat(pattern = "HH:mm:ss", timezone = "GMT+8")
    private Time businessStartTime;

    @ApiModelProperty("营业结束时间")
    @JsonFormat(pattern = "HH:mm:ss", timezone = "GMT+8")
    private Time businessEndTime;

    @ApiModelProperty("店铺简介")
    private String remark;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("店内环境照片，用英文逗号,分隔多张店照")
    private String shopEnvironmentPhotos;

    @ApiModelProperty("")
    private Integer masterUserId;

    @ApiModelProperty("店铺短码")
    private String shortCode;

    @ApiModelProperty("营业状态 1-营业中 2-停止营业")
    private Integer operatingStatus;

    private Double distance;

    private List<StoreGuideDTO> storeGuideDTOList;
}
