package com.gogirl.infrastructure.feign;

import com.gogirl.shared.admin.AdminResult;
import com.gogirl.shared.admin.dashboard.req.GetStoreListApiRequest;
import com.gogirl.shared.admin.dashboard.req.GetStoreTrendApiRequest;
import com.gogirl.shared.admin.dashboard.req.PreStorageSumApiRequest;
import com.gogirl.shared.admin.dashboard.resp.GetStoreTrendApiResp;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 管理后台接口
 * </p>
 *
 * @author robbendev
 * @since 2020/8/17 9:11 上午
 */
@FeignClient(url = "http://admin.begogirls.com:7712", value = "adminFeign", fallback = AdminFeign.AdminFeignFallback.class)
public interface AdminFeign {

    @PostMapping(value = "/api/ReportTable/GetStoreTrendApi",
            consumes = MediaType.APPLICATION_JSON_UTF8_VALUE,
            produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    AdminResult<GetStoreTrendApiResp> getStoreTrendApi(@RequestBody GetStoreTrendApiRequest request);

    @PostMapping(value = "/api/ReportTable/GetStoreListApi",
            consumes = MediaType.APPLICATION_JSON_UTF8_VALUE,
            produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    AdminResult<List<Map<String, Object>>> getStoreListApi(@RequestBody GetStoreListApiRequest request);

    @PostMapping(value = "/api/ReportTable/GetStoreListApi",
            consumes = MediaType.APPLICATION_JSON_UTF8_VALUE,
            produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    AdminResult<Map<String, Object>> preStorageSumApi(@RequestBody PreStorageSumApiRequest request);

    @Component
    class AdminFeignFallback implements AdminFeign {


        @Override
        public AdminResult<GetStoreTrendApiResp> getStoreTrendApi(GetStoreTrendApiRequest request) {
            return new AdminResult<>();
        }

        @Override
        public AdminResult<List<Map<String, Object>>> getStoreListApi(GetStoreListApiRequest request) {
            return new AdminResult<>();
        }

        @Override
        public AdminResult<Map<String, Object>> preStorageSumApi(PreStorageSumApiRequest request) {
            return null;
        }
    }
}
