package com.gogirl.infrastructure.mapper.order.mall;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gogirl.domain.product.mall.PurchaseSku;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;


public interface PurchaseSkuMapper extends BaseMapper<PurchaseSku> {

    /**
     * 根据分类查询产品sku列表
     *
     * @param purchaseSkuIPage
     * @param mallCategoryId
     * @return
     */
    IPage<PurchaseSku> queryPagePurchaseSku(IPage<PurchaseSku> purchaseSkuIPage, Long mallCategoryId);

    PurchaseSku selectBySkuName(String skuName);

    /**
     * @param produceId
     * @return
     */
    List<PurchaseSku> selectByProduceId(Integer produceId);


    List<PurchaseSku> getByProduceId(Integer produceId);
}
