package com.gogirl.application.store.store.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.order.serve.OrderManageService;
import com.gogirl.application.store.store.StoreTechnicianService;
import com.gogirl.application.xcx.GogirlTokenService;
import com.gogirl.application.xcx.WechatService;
import com.gogirl.domain.order.serve.OrderManage;
import com.gogirl.domain.store.store.StoreTechnician;
import com.gogirl.domain.xcx.GogirlToken;
import com.gogirl.infrastructure.common.exception.RRException;
import com.gogirl.infrastructure.common.util.ListUtil;
import com.gogirl.infrastructure.mapper.store.StoreTechnicianMapper;
import com.gogirl.infrastructure.mapper.store.UserTechnicianMapper;
import com.gogirl.infrastructure.mapper.xcx.GogirlTokenMapper;
import com.gogirl.shared.member.wx.query.dto.Code2SessionResult;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

@Slf4j
@Service
@AllArgsConstructor
@Transactional
public class StoreTechnicianServiceImpl extends ServiceImpl<StoreTechnicianMapper, StoreTechnician> implements StoreTechnicianService {

    private final UserTechnicianMapper StoreTechnicianMapper;

    public StoreTechnician getTechnicianManageForDetail(Integer id) {
        return StoreTechnicianMapper.getTechnicianManageForDetail(id);
    }

    public List<StoreTechnician> listTechnicianForPage(StoreTechnician technicianManage) {
        return StoreTechnicianMapper.listTechnicianForPage(technicianManage);
    }

    public List<StoreTechnician> getTechnicianManageByOpenid(String openid) {
        return StoreTechnicianMapper.getTechnicianManageByOpenid(openid);
    }

    public void updateTechnicianByAuthorityId(StoreTechnician item) {
        StoreTechnicianMapper.updateTechnicianByAuthorityId(item);
    }

    public List<StoreTechnician> queryDayTechnicianClasses(Integer departmentId, Date day) {
        return StoreTechnicianMapper.queryDayTechnicianClasses(departmentId, day);
    }

    private final WechatService wechatService;
    private final GogirlTokenMapper gogirlTokenMapper;

    @Override
    public String login(String code) {
        Code2SessionResult responseResult = wechatService.getTechnicianOpenidByCode(code);

        if (responseResult.getErrcode() != null) {
            throw new RRException(responseResult.getErrmsg());
        }

        String openid = responseResult.getOpenid();

        //生成token
        String token = new BigInteger((int) (Math.random() * 1000) + new SimpleDateFormat("ddHHmmss").format(new Date()), 10).toString(16);
        StoreTechnician storeTechnician = this.getOne(new LambdaQueryWrapper<StoreTechnician>().eq(StoreTechnician::getOpenid, openid));

        if (storeTechnician == null) {
            throw new RRException(2005, "请绑定手机号");
        }

        //美甲师token
        GogirlToken gogirlToken = new GogirlToken();
        gogirlToken.setSysId(2);
        gogirlToken.setOpenid(openid);
        // 返回美甲师信息及token
        gogirlToken.setCreateTime(new Date());
        gogirlToken.setUpdateTime(new Date());

        gogirlToken.setToken(token);
        if (storeTechnician != null) {
            gogirlToken.setTechnicianId(storeTechnician.getId());

        }
        //只写入token不写入美甲师因为美甲师是后台创建的 后台创建是美甲师唯一来源
        gogirlTokenMapper.insert(gogirlToken);

        return token;
    }

    private final GogirlTokenService gogirlTokenService;

    @Override
    public List<StoreTechnician> getTechnicianInfo(String token) {
        GogirlToken gogirlToken = gogirlTokenService.getByToken(token);

        //获取美甲师信息
        if (gogirlToken.getCustomerId() != null) {
            StoreTechnician storeTechnician = this.getTechnicianManageForDetail(gogirlToken.getCustomerId());
            List<StoreTechnician> list = Lists.newArrayList(storeTechnician);
            return list;
        }

        //token customerId为空
        else {
            StoreTechnician param = new StoreTechnician();
            param.setOpenid(gogirlToken.getOpenid());
            List<StoreTechnician> list = this.listTechnicianForPage(param);

            //选择门店
            if (ListUtil.isNotEmpty(list) && list.size() > 1) {
                log.info("美甲师选择门店");
            }

            //set customerId
            else if (ListUtil.isNotEmpty(list) && list.size() == 1) {
                gogirlToken.setCustomerId(list.get(0).getId());
                gogirlTokenMapper.updateById(gogirlToken);
                log.info("存在美甲师, setCustomerId (ssa.id)");
            }

            //list is empty
            else {
                log.info("绑定手机号");
            }
            return list;
        }
    }

    private final OrderManageService orderManageService;

    @Override
    public StoreTechnician choseStoreByOrderId(String token, Integer orderId) {
        GogirlToken gt = gogirlTokenService.getByToken(token);

        if (token == null || token.isEmpty()) {
            throw new RRException("入参token为空");
        }
        if (orderId == null) {
            throw new RRException("入参orderId为空");
        }
        if (gt == null) {
            throw new RRException("token过期");
        }
        OrderManage orderManage = orderManageService.queryOrder(orderId);
        if (orderManage == null) {
            throw new RRException("找不到订单");
        }
        if (orderManage.getDepartmentId() == null) {
            throw new RRException("订单无店铺");
        }

        List<StoreTechnician> listStoreTechnician = this.getTechnicianManageByOpenid(gt.getOpenid());
        if (listStoreTechnician == null) {
            throw new RRException("找不到该美甲师账号");
        }
        for (StoreTechnician storeTechnician : listStoreTechnician) {
            if (storeTechnician.getDepartmentId().equals(orderManage.getDepartmentId())) {
                GogirlToken gogirlToken = new GogirlToken();
                gogirlToken.setId(gt.getId());
                gogirlToken.setCustomerId(storeTechnician.getId());
                gogirlTokenService.updateById(gogirlToken);
                return storeTechnician;
            }
        }
        return null;
    }
}
