package com.gogirl.application.order.serve;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.gogirl.domain.order.serve.OrderManage;
import com.gogirl.domain.order.serve.OrderServe;
import com.gogirl.shared.member.CreateCommentCommand;
import com.gogirl.shared.order.CustomerOrder;
import com.gogirl.shared.order.ListOrderQuery;
import com.gogirl.shared.order.RecordOrderDataRequest;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * 购买美容服务产品的订单服务
 */
public interface OrderManageService extends IService<OrderManage> {


    /**
     * @param customerId
     * @param departmentId
     * @return
     */
    BigDecimal countSumPay(@Param("customerId") Integer customerId, @Param("departmentId") Integer departmentId);

    /**
     * 更新订单聚合
     *
     * @param param 订单更新参数
     */
    void updateOrderManage(OrderManage param);

    /**
     * 分页查询到订单
     *
     * @param qry
     * @return
     */
    IPage<OrderManage> queryListOrder(ListOrderQuery qry);

    /**
     * 核算订单
     *
     * @param orderId
     */
    void checkOrder(Integer orderId);

    /**
     * 美甲师录入款式/色号和款式描述
     *
     * @param param param
     */
    void recordOrderServeData(OrderServe param);


    /**
     * 美甲师录入订单资料
     *
     * @param recordOrderDataRequest
     */
    void recordOrderData(RecordOrderDataRequest recordOrderDataRequest);


    /**
     * 查询会员消费记录
     *
     * @param token      美甲师token
     * @param customerId customerId
     * @param pageNum
     * @param pageSize
     * @return
     */
    CustomerOrder queryCustomerOrder(String token, Integer customerId, Integer pageNum, Integer pageSize);


    /**
     * 查询订单详情dto
     *
     * @param id
     * @return
     */
    OrderManage queryOrder(Integer id);


    /**
     * 根据订单编号查询订单详情dto
     *
     * @param orderNo
     * @return
     */
    OrderManage queryOrderByOrderNo(String orderNo);

    /**
     * 发表订单评论
     *
     * @param cmd
     * @return
     */
    List<OrderServe> addOrModifyOrderComment(CreateCommentCommand cmd);


    /**
     * 美甲师确认收款
     *
     * @param orderId
     * @param payType
     * @param technicianId
     */
    void confirmOrder(Integer orderId, Integer payType, Integer technicianId);

    /**
     * 预约订单微信余额微信支付回调
     *
     * @param result 回调结果
     */
    void notifyBalanceWxPayOrder(WxPayOrderNotifyResult result);

    /**
     * 预约订单微信支付回调
     *
     * @param result 回调结果
     */
    void notifyWxPayOrder(WxPayOrderNotifyResult result);

    /**
     * 评论页面订单详情查询
     *
     * @param id
     * @return
     */
    OrderManage queryOrderForComment(Integer id);

    /**
     * 朋友代付
     *
     * @param orderId
     * @param phone
     */
    void friendPayOrder(Integer orderId, String phone);

    /**
     * 计算订单完整度
     *
     * @param orderId 订单
     * @return 订单信息完整度
     */
    Double countOrderDataRate(Integer orderId);
}
