package com.gogirl.interfaces.user.customer;


import com.gogirl.application.user.customer.IBeautyExpoQuestionnaireService;
import com.gogirl.domain.user.customer.BeautyExpoQuestionnaire;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.common.util.SessionUtils;
import com.gogirl.infrastructure.common.util.lock.CustomerIdLock;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author robbendev
 * @since 2020-07-24
 */
@RestController
@Api(tags = "美博会调查问卷")
public class BeautyExpoQuestionnaireController {
    @Resource
    IBeautyExpoQuestionnaireService beautyExpoQuestionnaireService;

    @ApiOperation("/是否已经填写美博会调查问卷")
    @GetMapping("/customer/beautyExpoQuestionnaire/hasSubmitted")
    public JsonResult<Boolean> hasSubmitted(@RequestParam Integer type) {
        return JsonResult.success(beautyExpoQuestionnaireService.hasSubmitted(SessionUtils.getCustomerId(), type));
    }

    @ApiOperation("/提交美博会调查问卷")
    @PostMapping("/customer/beautyExpoQuestionnaire/submitQuestionnaire")
    public JsonResult<Integer> submitQuestionnaire(@RequestBody BeautyExpoQuestionnaire beautyExpoQuestionnaire) {
        CustomerIdLock lock = CustomerIdLock.getInstance();
        Integer customerId = SessionUtils.getCustomerId();
        try {
            lock.lock(customerId);
            beautyExpoQuestionnaire.setCustomerId(customerId);
            BeautyExpoQuestionnaire result = beautyExpoQuestionnaireService.submitQuestionnaire(beautyExpoQuestionnaire);
            return JsonResult.success(result.getId());

        } finally {
            lock.unlock(customerId);
        }
    }
}
