package com.gogirl.interfaces.product.serve;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gogirl.application.product.serve.BaseServeService;
import com.gogirl.domain.product.serve.BaseServe;
import com.gogirl.infrastructure.common.annotation.AuthIgnore;
import com.gogirl.infrastructure.common.annotation.LoginIgnore;
import com.gogirl.infrastructure.common.base.JsonResult;
import com.gogirl.infrastructure.mapper.product.serve.BaseServeMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDateTime;

@RestController
@Api(tags = {"服务接口"}, value = "预约服务接口")
@AllArgsConstructor
@Slf4j
public class ServeController {

    private final BaseServeService baseServeService;
    private final BaseServeMapper baseServeMapper;

    @ApiOperation(value = "查看服务列表")
    @GetMapping("/customer/serve/no_queryServeForPage")
    @LoginIgnore
    @AuthIgnore
    public JsonResult<IPage<BaseServe>> no_queryServeForPage(BaseServe param,
                                                             Integer pageNum,
                                                             Integer pageSize) {

        IPage<BaseServe> page = new Page<>(pageNum == null ? 1 : pageNum, pageSize == null ? 20 : pageSize);
        page = baseServeService.listServeForPage(page, param);
        return JsonResult.success(page);
    }


    @ApiOperation(value = "查看服务详情")
    @GetMapping("/customer/serve/getServeDetail")
    public JsonResult<BaseServe> getServeDetail(@RequestParam Integer id,
                                                @RequestParam(required = false)
                                                @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss", iso = DateTimeFormat.ISO.DATE_TIME) LocalDateTime date,
                                                @RequestParam(required = false) Integer departmentId) {

        BaseServe baseServe = baseServeService.getAggregate(id);
        return JsonResult.success(baseServe);
    }


    @ApiOperation(value = "查看服务详情")
    @GetMapping("/technician/serve/getServeDetail")
    public JsonResult<BaseServe> techGetServeDetail(@RequestParam Integer id,
                                                    @RequestParam(required = false)
                                                    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss", iso = DateTimeFormat.ISO.DATE_TIME) LocalDateTime date,
                                                    @RequestParam(required = false) Integer departmentId) {
        BaseServe baseServe = baseServeService.getAggregate(id);
        return JsonResult.success(baseServe);
    }


    @RequestMapping(method = {RequestMethod.GET, RequestMethod.POST}, value = "/technician/serve/queryServeForPage")
    @ApiOperation(value = "查询服务款式", notes = "查看服务列表")
    public JsonResult<IPage<BaseServe>> queryServeForPage(BaseServe baseServe,
                                                          @RequestParam(required = false, defaultValue = "1") Integer pageNum,
                                                          @RequestParam(required = false, defaultValue = "20") Integer pageSize) {

        IPage<BaseServe> page = new Page<>(pageNum, pageSize);
        page = baseServeService.listServeForPage(page, baseServe);
        return JsonResult.success(page);
    }

}
