package com.gogirl.application.product.serve.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.product.serve.IProduceStorePriceService;
import com.gogirl.domain.product.serve.BaseProduce;
import com.gogirl.domain.product.serve.ProduceStorePrice;
import com.gogirl.infrastructure.common.util.SessionUtils;
import com.gogirl.infrastructure.mapper.product.serve.ProduceStorePriceMapper;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 店铺特殊价格配置 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-12-15
 */
@Service
public class ProduceStorePriceServiceImpl extends ServiceImpl<ProduceStorePriceMapper, ProduceStorePrice> implements IProduceStorePriceService {


    @Override
    public void setProduceStorePrice(BaseProduce baseProduce) {
        Integer departmentId = SessionUtils.getCustomerDepartmentId();

        ProduceStorePrice produceStorePrice = baseMapper.selectOne(new LambdaQueryWrapper<ProduceStorePrice>()
                .eq(ProduceStorePrice::getProduceId, baseProduce.getId())
                .eq(ProduceStorePrice::getStoreId, departmentId));

        if (produceStorePrice != null) {
            baseProduce.setBargainPrice(produceStorePrice.getBargainPrice());
        }
        if (produceStorePrice != null) {
            baseProduce.setBargainPrice(produceStorePrice.getBargainPrice());
        }
    }


    @Override
    public void setProduceStorePrice(List<BaseProduce> baseProduceList) {
        Integer departmentId = SessionUtils.getCustomerDepartmentId();

        List<ProduceStorePrice> produceStorePriceList = baseMapper.selectList(new LambdaQueryWrapper<ProduceStorePrice>()
                .in(ProduceStorePrice::getProduceId, baseProduceList.stream().map(BaseProduce::getId).collect(Collectors.toList()))
                .eq(ProduceStorePrice::getStoreId, departmentId));

        Map<Integer, ProduceStorePrice> map = produceStorePriceList.stream().collect(Collectors.toMap(ProduceStorePrice::getProduceId, produceStorePrice -> produceStorePrice));

        baseProduceList.forEach(baseProduce -> {
            ProduceStorePrice produceStorePrice = map.get(baseProduce.getId());
            if (produceStorePrice != null) {
                baseProduce.setBargainPrice(produceStorePrice.getBargainPrice());
            }
            if (produceStorePrice != null) {
                baseProduce.setBargainPrice(produceStorePrice.getBargainPrice());
            }
        });

    }
}
