package com.gogirl.infrastructure.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.gogirl.infrastructure.interceptor.LogHandlerInterceptor;
import com.gogirl.infrastructure.interceptor.LoginHandlerInterceptor;
import lombok.AllArgsConstructor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;

import java.text.SimpleDateFormat;

@Configuration
@AllArgsConstructor
public class MvcInterceptorConfig extends WebMvcConfigurationSupport {

    private final LoginHandlerInterceptor loginHandlerInterceptor;
    private final LogHandlerInterceptor logHandlerInterceptor;

    @Override
    protected void addInterceptors(InterceptorRegistry registry) {

        /*多个拦截器组成一个拦截器链*/
        /*addPathPatterns 用于添加拦截规则*/
        /* **表示拦截所有请求*/
        /*excludePathPatterns 用户排除拦截*/
        registry.addInterceptor(loginHandlerInterceptor).addPathPatterns("/**")
                .excludePathPatterns("/swagger-resources/**", "/webjars/**", "/v2/**", "/swagger-ui.html/**")
                //登陆
                .excludePathPatterns("/customer/xcx/login")
                .excludePathPatterns("/customer/csrf")
                .excludePathPatterns("/customer/mallCategory/getCategoryTree")
                .excludePathPatterns("/customer/mallCategory/getCategoryList")
                .excludePathPatterns("/customer/mallProduct/queryPageProduct")
                .excludePathPatterns("/customer/mallProduct/queryProduct")
                .excludePathPatterns("/customer/serve/no_queryNewServePage")
                .excludePathPatterns("/customer/serve/queryServeForPage")
                .excludePathPatterns("/customer/broadcast/queryBroadcast")
                .excludePathPatterns("/customer/shop/queryShopEnvironmentPhotos")
                //回调
                .excludePathPatterns("/customer/pay/notifyTimesCard")
                .excludePathPatterns("/customer/pay/notifyCharge")
                .excludePathPatterns("/customer/mallOrderPay/notifyMallOrder")

                .excludePathPatterns("/customer/xcx/authorized1")
                .excludePathPatterns("/customer/xcx/authorizedPhone")
                .excludePathPatterns("/customer/pay/notifyOrder")
                .excludePathPatterns("/customer/pay/notifyBalanceWxPay")

                //退款
                .excludePathPatterns("/customer/mallOrderPay/refund/*")
                .excludePathPatterns("/customer/xcx/upload")

                .excludePathPatterns("/technician/xcx/login")
                .excludePathPatterns("/csrf")
                .excludePathPatterns("/technician/xcx/login_t")
                .excludePathPatterns("/technician/phone/bindPhone_t")
                .excludePathPatterns("/technician/phone/getBindCode")
                .excludePathPatterns("/technician/xcx/upload")
//                .excludePathPatterns("/technician/xcx/getUserInfo_t")
                .excludePathPatterns("/technician/xcx/choseStore");
        ;

        registry.addInterceptor(logHandlerInterceptor);

        super.addInterceptors(registry);
    }

    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {

        //swagger增加url映射
        registry.addResourceHandler("/swagger-ui.html")
                .addResourceLocations("classpath:/META-INF/resources/");

        registry.addResourceHandler("/webjars/**")
                .addResourceLocations("classpath:/META-INF/resources/webjars/");
    }

    /*定义时间格式转换器*/
    @Bean
    public MappingJackson2HttpMessageConverter jackson2HttpMessageConverter() {
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setDateFormat(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        converter.setObjectMapper(mapper);
        return converter;
    }


}


