package com.gogirl.shared.order;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.gogirl.domain.user.customer.Customer;
import com.gogirl.shared.market.CouponCustomerRelevanceDTO;
import com.gogirl.shared.market.TimesCardUsedRecordDTO;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@Data
public class OrderManageDTO {


    private Integer id;

    @ApiModelProperty("订单no")
    private String orderNo;

    @ApiModelProperty("用户id")
    private Integer orderUser;

    @ApiModelProperty("用户电话号码")
    private String telephone;

    @ApiModelProperty("预约用户名")
    private String storeScheduleUsername;

    @ApiModelProperty("店铺编号")
    private Integer departmentId;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")

    @ApiModelProperty("店铺名")
    private String departmentName;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("修改时间")
    private Date updateTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("开始付款时间")
    private Date launchTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("完成时间")
    private Date finishTime;

    @ApiModelProperty("总价")
    private BigDecimal totalPrice;

    @ApiModelProperty("改价（有正负）")
    private BigDecimal changePrice;

    @ApiModelProperty("折扣金额")
    private BigDecimal discountPrice;

    @ApiModelProperty("总支付金额")
    private BigDecimal totalPaymentAmount;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("支付备注")
    private String message;

    @ApiModelProperty("关联预约id")
    private Integer scheduledId;

    @ApiModelProperty("开单人id")
    private Integer openOrderUser;

    @ApiModelProperty("创建人")
    private String createUser;

    @ApiModelProperty("多选支付方式 200-pos机 100-现金 50-微信扫码")
    private String multiplePaymentType;

    @ApiModelProperty("支付方式：1#微信 2#会员 3#其他4#充值5#pos机6#现金7#大众点评8#微信扫码支付9#团购10#免单11#会员帮付12余额微信支付")
    private Integer paymentType;

    @ApiModelProperty("订单类型 1#预约生成订单 2#线下订单 3#大众点评订单 4#充值生成订单 5#总后台预约6.小程序预约")
    private Integer orderType;

    @ApiModelProperty("1正在服务# 2待付款#  3未评价# 4已完成# 5已删除#6 已预约待接单7 用户取消 8.待确认支付 9.超时系统取消")
    private Integer status;

    @ApiModelProperty("是否已推送 1#未推送 2#已推送")
    private String isReminder;

    @ApiModelProperty("数据完整度")
    private Double dataIntegrity;

    @ApiModelProperty("删除备注")
    private String delRemark;

    @ApiModelProperty("预约时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date arriveTime;

    @ApiModelProperty("1-接受 2-不接受")
    private String afterSaleIsBuyCard;

    private String afterSaleBuyCardReason;

    @ApiModelProperty("订单详情")
    private List<OrderServeDTO> orderServeDTOList;

    @ApiModelProperty("订单使用的卡券列表")
    private List<CouponCustomerRelevanceDTO> couponCustomerRelevanceDTOList;

    @ApiModelProperty("订单使用的次卡列表")
    private List<TimesCardUsedRecordDTO> timesCardUsedRecordDTOList;

    @ApiModelProperty("订单全部客照片")
    private Set<String> images;

    @ApiModelProperty("订单关联的预约")
    private ScheduleManageDTO scheduleManageDTO;

    private List<Integer> couponCustomerRelevanceIds;

    private Integer payUser;

    @ApiModelProperty("是否朋友代付 1-是 2-否")
    private Integer isFriendPay;

    @TableField(exist = false)
    @ApiModelProperty("下单用户信息")
    private Customer customer;

    @TableField(exist = false)
    @ApiModelProperty("支付用户信息")
    private Customer payCustomer;

    @ApiModelProperty("环境评分")
    private Integer environmentStar;

    public void setImages() {
        images = orderServeDTOList
                .stream()
                .map(OrderServeDTO::getOrderRecordDTO)
                .filter(Objects::nonNull)
                //获取服务记录客人照片
                .map(OrderRecordDTO::getPicturePath)
                .filter(Objects::nonNull)
                .map(pic -> Lists.newArrayList(pic.split(",")))
                .flatMap(List::stream)
                .collect(Collectors.toSet());
    }
}
