package com.gogirl.domain.order.pay;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 订单支付明细
 * </p>
 *
 * @author robbendev
 * @since 2020-03-12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "OrderPay对象", description = "订单支付明细")
public class OrderPay implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "订单id")
    private Integer orderId;

    @ApiModelProperty(value = "微信 = 1, 会员 = 2, 充值 = 4, pos机 = 5, 大众点评 = 7, 会员帮付 = 11, 次卡 =12")
    private Integer type;

    @ApiModelProperty(value = "金额")
    private BigDecimal amount;


}
