package com.gogirl.application.user.investigation.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gogirl.application.market.coupon.CouponService;
import com.gogirl.application.store.complaint.ComplaintMainService;
import com.gogirl.application.user.investigation.BaseQuestionService;
import com.gogirl.application.user.investigation.OrderQuestionOptionService;
import com.gogirl.application.user.investigation.TestPaperQuestionService;
import com.gogirl.domain.market.coupon.Coupon;
import com.gogirl.domain.user.investigation.*;
import com.gogirl.infrastructure.mapper.user.investigation.BaseQuestionMapper;
import com.gogirl.infrastructure.mapper.user.investigation.TestPaperCustomerMapMapper;
import com.gogirl.infrastructure.mapper.user.investigation.TestPaperMapper;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Service
@AllArgsConstructor
@Slf4j
public class BaseQuestionServiceImpl extends ServiceImpl<BaseQuestionMapper, BaseQuestion> implements BaseQuestionService {

    private final BaseQuestionMapper baseQuestionMapper;
    private final TestPaperMapper testPaperMapper;
    private final TestPaperCustomerMapMapper testPaperCustomerMapMapper;
    private final TestPaperQuestionService testPaperQuestionService;
    private final OrderQuestionOptionService orderQuestionOptionService;
    private final ComplaintMainService complaintMainService;

    private final CouponService couponService;

    @Override
    public List<BaseQuestion> getTestPaper(Integer currentCustomerId) {
        return baseQuestionMapper.getTestPaper(currentCustomerId);
    }

    @Override
    public void submitTestPaper(Integer currentCustomerId, List<OrderQuestionOption> list) {
        TestPaper testPaper = new TestPaper();
        testPaper.setCreateDate(new Date());
        testPaper.setCreateUser(currentCustomerId);
        testPaper.setName("问卷调查");
        testPaperMapper.insert(testPaper);

        TestPaperCustomerMap testPaperCustomerMap = new TestPaperCustomerMap();
        testPaperCustomerMap.setCreateDate(new Date());
        testPaperCustomerMap.setCustomerId(currentCustomerId);
        testPaperCustomerMap.setTestPaperId(testPaper.getId());
        testPaperCustomerMapMapper.insert(testPaperCustomerMap);


        List<TestPaperQuestion> testPaperQuestionList = list.stream()
                .map(orderQuestionOption -> {
                    TestPaperQuestion testPaperQuestion = new TestPaperQuestion();
                    testPaperQuestion.setQuestionId(orderQuestionOption.getQuestionId());
                    testPaperQuestion.setTestPaperId(testPaper.getId());
                    return testPaperQuestion;
                })
                .collect(Collectors.toList());
        testPaperQuestionService.saveBatch(testPaperQuestionList);


        list.forEach(orderQuestionOption -> {
            orderQuestionOption.setCustomerId(currentCustomerId);
            orderQuestionOption.setTestPaperCustomerMapId(testPaperCustomerMap.getId());
            orderQuestionOption.setCreateTime(new Date());

        });
        orderQuestionOptionService.saveBatch(list);

        complaintMainService.saveComplainsByOrderQuestion(list);

        Coupon coupon = couponService.getOne(new LambdaQueryWrapper<Coupon>().eq(Coupon::getName, "问卷调查礼券"));
        if (coupon != null) {
            couponService.sendCoupon(coupon.getId(), currentCustomerId);
        }
    }


}
