package com.gogirl.domain.order.serve;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.gogirl.domain.market.serve.CouponCustomerRelevance;
import com.gogirl.domain.market.serve.CouponOrderRelevance;
import com.gogirl.domain.market.serve.TimesCardUsedRecord;
import com.gogirl.domain.store.store.StoreUser;
import com.gogirl.domain.user.Customer;
import com.gogirl.domain.user.CustomerBalanceRecord;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * Created by yinyong on 2018/9/18.
 */
@ApiModel("购买美甲服务订单表")
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@TableName("order_manage")
public class OrderManage implements Serializable {

    /**
     * 1正在服务# 2待付款#  3未评价# 4已完成# 5已删除#6 已预约待接单7 用户取消 8.待确认支付 9.超时系统取消
     */
    public static final Integer STATUS_IN_SERVING = 1;
    //待支付
    public static final Integer STATUS_UN_PAY = 2;
    //待确认
    public static final Integer STATUS_UN_CONFIRM = 8;
    //待评论
    public static final Integer STATUS_UN_COMMENT = 3;
    //已完成
    public static final Integer STATUS_FINISHED = 4;
    //已删除
    public static final Integer STATUS_DELETED = 5;
    //用户取消
    public static final Integer STATUS_USER_CANCEL = 7;
    //系统取消
    public static final Integer STATUS_SYSTEM_CANCEL = 9;
    public static final Integer STATUS_SYSTEM_UN_CHECK = 11;
    /**
     * 支付方式：1#微信 2#会员 3#其他 4#充值 5#pos机 6#现金 7#大众点评 8#微信扫码支付 9#团购 10#免单 11#会员帮付
     */
    //微信支付
    public static final Integer PAYMENT_WX = 1;
    //会员支付
    public static final Integer PAYMENT_BALANCE = 2;
    //其他
    public static final Integer PAYMENT_OTHER = 3;
    //充值
    public static final Integer PAYMENT_CHARGE = 4;
    //POS机器
    public static final Integer PAYMENT_POS = 5;
    //现金
    public static final Integer PAYMENT_CASH = 6;
    //大众点评
    public static final Integer PAYMENT_DZ = 7;
    //微信扫码支付
    public static final Integer PAYMENT_WX_SCAN = 8;
    //团购
    public static final Integer PAYMENT_GROUP = 9;
    //免单
    public static final Integer PAYMENT_FREE = 10;
    //会员帮付
    public static final Integer PAYMENT_FRIEND_PAY = 11;
    //
    public static final Integer TYPE_CUSTOMER = 6;
    public static final Integer TYPE_STORE = 5;


    @TableId(type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty("订单编号")
    private String orderNo;

    @ApiModelProperty("用户id")
    private Integer orderUser;

    @ApiModelProperty("用户电话号码")
    private String telephone;

    @ApiModelProperty("预约用户名")
    private String storeScheduleUsername;

    @ApiModelProperty("店铺编号")
    private Integer departmentId;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("创建时间")
    private Date createTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("修改时间")
    private Date updateTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("开始付款时间")
    private Date launchTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("完成时间")
    private Date finishTime;

    @ApiModelProperty("总价")
    private BigDecimal totalPrice;

    @ApiModelProperty("总的改价（有正负）")
    private BigDecimal changePrice;

    @ApiModelProperty("打折抵扣价格")
    private BigDecimal discountPrice;

    @ApiModelProperty("总支付金额")
    private BigDecimal totalPaymentAmount;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("支付备注")
    private String message;

    @ApiModelProperty("关联预约id")
    private Integer scheduledId;

    @ApiModelProperty("开单人id")
    private Integer openOrderUser;

    @ApiModelProperty("创建人")
    private String createUser;

    @ApiModelProperty("多选支付方式 200-pos机 100-现金 50-微信扫码")
    private String multiplePaymentType;

    @ApiModelProperty("支付方式：1#微信 2#会员 3#其他4#充值5#pos机6#现金7#大众点评8#微信扫码支付9#团购10#免单11#会员帮付")
    private Integer paymentType;

    @ApiModelProperty("订单类型 1#预约生成订单 2#线下订单 3#大众点评订单 4#充值生成订单 5#总后台预约6.小程序预约")
    private Integer orderType;

    @ApiModelProperty("1正在服务# 2待付款# 3未评价# 4已完成# 5已删除#6 已预约待接单7 用户取消 8.待确认支付 9超时系统取消 10-客服取消 11-待核算")
    private Integer status;

    @TableField(value = "is_reminder")
    @ApiModelProperty("是否已推送 1#未推送 2#已推送")

    private String reminder;
    @ApiModelProperty("数据完整度")

    private Double dataIntegrity;
    @ApiModelProperty("删除备注")

    private String delRemark;
    @ApiModelProperty("预约时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date arriveTime;

    @ApiModelProperty("1-接受 2-不接受")
    private String afterSaleIsBuyCard;

    @ApiModelProperty("不接受开卡的理由")
    private String afterSaleBuyCardReason;

    @ApiModelProperty("卡券id")
    private Integer couponRelevanceId;

    @ApiModelProperty("店铺名字")
    private String departmentName;

    /**
     * 非数据库字段
     */
    @TableField(exist = false)
    @ApiModelProperty("优惠券实际价格")
    private BigDecimal couponRelevancePrice;

    @TableField(exist = false)
    @ApiModelProperty("是否改价")
    private String changeStatus = "false";

    @TableField(exist = false)
    @ApiModelProperty("删除订单")
    private String deleteOrder;

    @TableField(exist = false)
    @ApiModelProperty("预约用户信息")
    private Customer customer;

    @TableField(exist = false)
    @ApiModelProperty("导出订单按月份")
    private String exportTime;

    @TableField(exist = false)
    @ApiModelProperty("统计开始时间")
    private String startTime;

    @TableField(exist = false)
    @ApiModelProperty("统计结束时间")
    private String endTime;

    @TableField(exist = false)
    @ApiModelProperty("是否是收款")
    private String receipt;

    @TableField(exist = false)
    @ApiModelProperty("开单人")
    private StoreUser userManage;

    @TableField(exist = false)
    @ApiModelProperty("预约建立时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date scheduledTime;

    @TableField(exist = false)
    @ApiModelProperty("信息填写")
    private String dataInfo;

    @TableField(exist = false)
    private String token;

    @TableField(exist = false)
    private Set<String> images;

    @TableField(exist = false)
    private ScheduleManage scheduleManage;

    @ApiModelProperty("订单服务列表")
    @TableField(exist = false)
    private List<OrderServe> listOrderServer;

    @TableField(exist = false)
    private List<CouponOrderRelevance> listCouponOrderRelevance;

    @ApiModelProperty("订单使用的卡券列表")
    @TableField(exist = false)
    private List<CouponCustomerRelevance> couponCustomerRelevanceList;

    @ApiModelProperty("订单关联的消费列表")
    @TableField(exist = false)
    private List<CustomerBalanceRecord> listCustomerBalanceRecord;

    @ApiModelProperty("订单使用的次卡列表")
    @TableField(exist = false)
    private List<TimesCardUsedRecord> listTimesCardRecord;

}
