package com.gogirl.interfaces.market.discount;

import com.gogirl.application.market.discount.DiscountConfigService;
import com.gogirl.domain.market.discount.DiscountConfig;
import com.gogirl.infrastructure.common.annotation.AuthIgnore;
import com.gogirl.infrastructure.common.base.JsonResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Api(tags = {"折扣接口"}, value = "折扣接口")
@RestController
@Slf4j
@AllArgsConstructor
public class DiscountConfigController {

    private final DiscountConfigService discountConfigService;

    @AuthIgnore
    @ApiOperation(value = "查询充送信息")
    @GetMapping("/customer/selectAllDiscount")
    public JsonResult<Map<String, Object>> selectAllDiscount() {
        List<DiscountConfig> list = discountConfigService.selectAllDiscount();
        Map<String, Object> map = new HashMap<>();
        map.put("list", list);
        return JsonResult.success(map);
    }


    @ApiOperation(value = "查询充送信息", notes = "")
    @GetMapping("/technician/selectAllDiscount")
    public JsonResult<Map<String, Object>> techSelectAllDiscount() {
        List<DiscountConfig> list = discountConfigService.selectAllDiscount();
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("list", list);
        return new JsonResult<>(true, JsonResult.APP_DEFINE_SUC, map);
    }
}
