package com.gogirl.infrastructure.config;


import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix = "wechat")
@Data
public class WxProperties {
    /**
     * 微信公众号
     */
    public String mpAppId;
    public String mpSecret;

    /**
     * 用户端gogirl小程序
     */
    public String customerMiniAppId;
    public String customerMiniSecret;
    /**
     * 店员端gogirl小程序
     */
    public String storeMiniAppId;
    public String storeMiniSecret;

    /**
     * 预约提醒订阅消息模板id
     */
    private String scheduleTpl;

    /**
     * 预约过期订阅消息模板id
     */
    private String overScheduleTpl;
    /**
     * 支付成功订阅消息模板id
     */
    private String paySuccessTpl;

    /**
     * 订单支付订阅消息模板id
     */
    private String orderPayNotifyTpl;


    public String testPaperTpl;

    private String shopScheduleTpl;

    private String shopOverScheduleTpl;

    private String shopCancelScheduleTpl;
}
