package com.gogirl.application.order.serve;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.gogirl.domain.order.serve.ScheduleManage;
import com.gogirl.domain.store.store.StoreTechnician;
import com.gogirl.shared.order.*;
import com.gogirl.shared.product.LeisureScheduleServeQuery;
import com.gogirl.shared.product.LeisureScheduleServeResp;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

/**
 * 预约service
 */
public interface ScheduleManageService extends IService<ScheduleManage> {


    /**
     * 普通预约入口查询预约时间
     *
     * @param query param
     * @return list
     * @throws ParseException exception
     */
    List<IdleTimeDTO> queryIdleTime(IdleTimeQuery query) throws ParseException, ExecutionException, InterruptedException;


    /**
     * 取消预约
     *
     * @param cmd
     */
    void cancelSchedule(CancelScheduleCommand cmd);


    /**
     * 更新预约状态
     *
     * @param scheduleServeId 预约服务id
     * @param status          状态
     */
    void updateScheduledServeStatus(Integer scheduleServeId, Integer status, Integer forceLeisureConfig);

    /**
     * 美甲师接单前检查预约
     *
     * @param technicianId
     * @param scheduleId
     */
    void checkBeforeTakeOrders(Integer technicianId, Integer scheduleId);

    /**
     * 提交预约
     *
     * @param cmd 提交预约命令
     */
    void submitSchedule(SubmitScheduleCommand cmd) throws ParseException, ExecutionException, InterruptedException;

    /**
     * 更新预约
     *
     * @param cmd
     * @return
     */
    void updateSchedule(SubmitScheduleCommand cmd) throws ParseException, ExecutionException, InterruptedException;

    /**
     * 更新预约前检查
     *
     * @param cmd
     */
    void checkBeforeUpdate(UpdateScheduleCommand cmd);

    /**
     * 店员获取时间列表
     *
     * @param startDate
     * @param lengthTime
     * @param departmentId
     * @param orderId
     * @param needRemoveOldServe
     * @return
     */
    List<Map<String, Object>> queryReservableTime(String startDate, Integer lengthTime, Integer departmentId, Integer orderId, Boolean needRemoveOldServe);

    /**
     * 查询预约聚合
     *
     * @param id
     * @return
     */
    ScheduleManage queryScheduleManage(Integer id);

    /**
     * 分页查询预约
     *
     * @param qry
     * @return
     */
    IPage<ScheduleManage> queryPageScheduleManage(ScheduleManagePageQuery qry);

    /**
     * 当前服务是否在闲时 1-是 2-否
     *
     * @param scheduleServeId
     * @return
     */
    Integer getScheduledServeLeisure(Integer scheduleServeId);

    /**
     * 查询闲时预约列表
     *
     * @param query
     * @return
     */
    IPage<LeisureScheduleServeResp> queryPageLeisureScheduleServe(LeisureScheduleServeQuery query);

    /**
     * 查询店铺下的美甲师和美甲师不可用时间段
     *
     * @param scheduledId  是否必传：否。为过滤条件，如果是修改的话传预约id在查询不可用时间段的时候会过滤被修改的预约。
     * @param departmentId 店铺id
     * @param day          日期 形如yyyy-MM-dd
     * @param serveIdList  预约的服务id。为过滤条件：过滤不能做服务的美甲师id
     * @return departmentId下的美甲师和美甲师不可用时间段
     * @throws ParseException
     */
    List<StoreTechnicianPeriod> queryStoreTechnicianPeriod(@Null Integer scheduledId,
                                                           @NotNull Integer departmentId,
                                                           @NotNull String day,
                                                           @Null List<Integer> serveIdList) throws ParseException;

    /**
     * 查询店铺下能做服务的美甲师
     *
     * @param departmentId   店铺id
     * @param serveId        服务id
     * @param serveStartTime 服务开始时间
     * @param serveEndTime   服务结束时间
     * @return
     * @throws ParseException
     */
    List<StoreTechnician> queryAvailableTechnician(Integer departmentId, Integer serveId, LocalDateTime serveStartTime, LocalDateTime serveEndTime) throws ParseException;
}
