package com.gogirl.domain.store.training;


import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.gogirl.infrastructure.common.annotation.DictParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@TableName("training_start_class_log_technician")
@ApiModel("每次开课 参与的美甲师")
public class TrainingStartClassLogTechnician implements Serializable {

    @TableId(type = IdType.AUTO)
    private Integer id;

    private Integer technicianId;

    private Date createDate;

    private String feedback;

    private Date feedbackTime;

    private Integer trainingStartClassId;

    @ApiModelProperty("签到情况 1-已签到 2-无签到记录")
    @DictParam(dictCode = "TRAINING_START_CLASS_LOG_TECHNICIAN_SIGN_STATUS", dictValueParam = "signStatusStr")
    private Integer signStatus;

    @TableField(exist = false)
    @ApiModelProperty("签到情况 1-已签到 2-无签到记录")
    private String signStatusStr;

    @ApiModelProperty("课堂考勤 1-正常 2-迟到15分钟 3-迟到30分钟")
    @DictParam(dictCode = "TRAINING_START_CLASS_LOG_TECHNICIAN_ATTENDANCE_STATUS", dictValueParam = "attendanceStatusStr")
    private Integer attendanceStatus;

    @TableField(exist = false)
    private String attendanceStatusStr;

    @DictParam(dictCode = "TRAINING_START_CLASS_LOG_TECHNICIAN_COMPLETE_STATUS", dictValueParam = "completeStatusStr")
    @ApiModelProperty("随堂完成 1-优 2-完成 3-一般")
    private Integer completeStatus;

    @TableField(exist = false)
    private String completeStatusStr;

    @ApiModelProperty("课上评价")
    private String classEvaluation;

    @ApiModelProperty("品牌ID")
    private Integer brandId;

    @DictParam(dictCode = "TRAINING_START_CLASS_LOG_TECHNICIAN_CLASS_EVALUATION_RESULT", dictValueParam = "classEvaluationResultStr")
    @ApiModelProperty("课堂评估结果 1-通过 2-不通过")
    private Integer classEvaluationResult;

    @ApiModelProperty("课堂评估结果 1-通过 2-不通过")
    @TableField(exist = false)
    private String classEvaluationResultStr;

    @ApiModelProperty("开课记录")
    @TableField(exist = false)
    private TrainingStartClass trainingStartClass;

    @ApiModelProperty("反馈记录")
    @TableField(exist = false)
    private TrainingFeedback trainingFeedback;
}
