FROM maven:3.6.3-jdk-8

RUN mkdir -p /usr/app
WORKDIR /usr/app
# install maven dependency packages (keep in image)

#系统编码
ENV LANG C.UTF-8
ENV LANGUAGE C.UTF-8
ENV LC_ALL C.UTF-8
ENV TZ Asia/Shanghai

#声明一个挂载点，容器内此路径会对应宿主机的某个文件夹
#VOLUME /tmp

# VOLUME /usr/app/gogirl-miniapp-backend
RUN cd ../ && ls -a

COPY ./ /usr/app/gogirl-miniapp-backend

RUN cd /usr/app/gogirl-miniapp-backend && ls -a && mvn -T 1C install

#应用构建成功后的jar文件被复制到镜像内，名字也改成了app.jar
#ADD target/singlewindow-0.0.1-SNAPSHOT.jar app.jar

#启动容器时的进程
ENTRYPOINT ["java","-jar","/usr/app/gogirl-miniapp-backend/target/gogirl-miniapp-backend-0.0.1-SNAPSHOT.jar"]

#暴露8080端口
#EXPOSE 8080
