package com.gogirl.shared.product.query.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
@ApiModel("小程序商城分类")
public class MallCategoryDTO {


    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("父分类id")
    private Long parentId;

    @ApiModelProperty("分类名称")
    private String categoryName;

    private String picturePath;

    @ApiModelProperty("子节点")
    private List<MallCategoryDTO> childList;
}
