package com.gogirl.assembler;

import com.gogirl.domain.store.career.Works;
import com.gogirl.domain.store.career.WorksImages;
import com.gogirl.infrastructure.common.util.ListUtil;
import com.gogirl.shared.store.query.dto.WorksDTO;
import com.gogirl.shared.store.query.dto.WorksImagesDTO;
import lombok.AllArgsConstructor;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

import java.util.function.Function;
import java.util.stream.Collectors;

@Component
@AllArgsConstructor
public class WorksAssembler implements Function<Works, WorksDTO> {

    private final WorksImagesDTOAssembler worksImagesDTOAssembler;

    @Override
    public WorksDTO apply(Works works) {
        WorksDTO worksDTO = new WorksDTO();
        BeanUtils.copyProperties(works, worksDTO);

        if(ListUtil.isNotEmpty(works.getWorksImagesList())){
            worksDTO.setWorksImagesDTOList(
                    works.getWorksImagesList()
                            .stream()
                            .map(worksImagesDTOAssembler)
                            .collect(Collectors.toList())
            );
        }
        return worksDTO;
    }

    @Component
    static class WorksImagesDTOAssembler implements Function<WorksImages, WorksImagesDTO> {

        @Override
        public WorksImagesDTO apply(WorksImages worksImages) {
            WorksImagesDTO worksImagesDTO = new WorksImagesDTO();
            BeanUtils.copyProperties(worksImages, worksImagesDTO);
            return worksImagesDTO;
        }
    }
}
